/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;

public class SerialNumberCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public SerialNumberCheck(XmlSubXCV result, CertificateWrapper certificate, LevelConstraint constraint) {
        super(result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        return Utils.isStringNotBlank(this.certificate.getSerialNumber());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_UNIQUE_CERT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_UNIQUE_CERT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

