/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class RevocationCertHashMatchCheck
extends ChainItem<XmlSubXCV> {
    private final List<CertificateRevocationWrapper> certificateRevocations;

    public RevocationCertHashMatchCheck(XmlSubXCV result, List<CertificateRevocationWrapper> certificateRevocations, LevelConstraint constraint) {
        super(result, constraint);
        this.certificateRevocations = certificateRevocations;
    }

    @Override
    protected boolean process() {
        if (Utils.isCollectionNotEmpty(this.certificateRevocations)) {
            for (RevocationWrapper revocationWrapper : this.certificateRevocations) {
                if (!revocationWrapper.isCertHashExtensionPresent() || revocationWrapper.isCertHashExtensionMatch()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_REVOC_CERT_HASH;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_REVOC_CERT_HASH_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

