/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CertificateExpirationCheck
extends ChainItem<XmlSubXCV> {
    private final Date currentTime;
    private final CertificateWrapper certificate;

    public CertificateExpirationCheck(XmlSubXCV result, CertificateWrapper certificate, Date currentTime, LevelConstraint constraint) {
        super(result, constraint);
        this.currentTime = currentTime;
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        Date notBefore = this.certificate.getNotBefore();
        Date notAfter = this.certificate.getNotAfter();
        return notBefore != null && this.currentTime.compareTo(notBefore) >= 0 && notAfter != null && this.currentTime.compareTo(notAfter) <= 0;
    }

    @Override
    protected String getAdditionalInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String notBeforeStr = this.certificate.getNotBefore() == null ? " ? " : sdf.format(this.certificate.getNotBefore());
        String notAfterStr = this.certificate.getNotAfter() == null ? " ? " : sdf.format(this.certificate.getNotAfter());
        Object[] params = new Object[]{notBeforeStr, notAfterStr};
        return MessageFormat.format("Certificate validity : {0} to {1}", params);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRSC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICTIVRSC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.OUT_OF_BOUNDS_NO_POE;
    }
}

