/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.Date;

public class NextUpdateCheck
extends ChainItem<XmlRFC> {
    private final RevocationWrapper revocationData;

    public NextUpdateCheck(XmlRFC result, RevocationWrapper revocationData, LevelConstraint constraint) {
        super(result, constraint);
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        if (this.revocationData != null) {
            Date nextUpdate = this.revocationData.getNextUpdate();
            return nextUpdate != null;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_RFC_NUP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_RFC_NUP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

