/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.vci.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignaturePolicyType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;

public class SignaturePolicyIdentifierCheck
extends AbstractMultiValuesCheckItem<XmlVCI> {
    private final SignatureWrapper signature;
    private final MultiValuesConstraint multiValues;

    public SignaturePolicyIdentifierCheck(XmlVCI result, SignatureWrapper signature, MultiValuesConstraint multiValues) {
        super(result, multiValues);
        this.signature = signature;
        this.multiValues = multiValues;
    }

    @Override
    protected boolean process() {
        String policyId = this.signature.getPolicyId();
        if (this.multiValues.getId().contains(SignaturePolicyType.NO_POLICY.name()) && Utils.isStringEmpty(policyId)) {
            return true;
        }
        if (this.multiValues.getId().contains(SignaturePolicyType.ANY_POLICY.name()) && Utils.isStringNotEmpty(policyId)) {
            return true;
        }
        if (this.multiValues.getId().contains(SignaturePolicyType.IMPLICIT_POLICY.name()) && Utils.areStringsEqual(SignaturePolicyType.IMPLICIT_POLICY.name(), policyId)) {
            return true;
        }
        return this.processValueCheck(policyId);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_VCI_ISPK;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_VCI_ISPK_ANS_1;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.POLICY_PROCESSING_ERROR;
    }
}

