/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class ContentTimestampCheck
extends ChainItem<XmlSAV> {
    private final SignatureWrapper signature;

    public ContentTimestampCheck(XmlSAV result, SignatureWrapper signature, LevelConstraint constraint) {
        super(result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        List<TimestampWrapper> timestampList = this.signature.getTimestampList();
        for (TimestampWrapper timestampWrapper : timestampList) {
            if (!timestampWrapper.getType().isContentTimestamp()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISQPCTSIP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISQPCTSIP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

