/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.AbstractAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CertifiedRolesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ClaimedRolesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CommitmentTypeIndicationsCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentHintsCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTimestampCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.ContentTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CounterSignatureCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.MessageDigestOrSignedPropertiesCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignerLocationCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SigningTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.StructuralValidationCheck;
import java.util.Date;

public class SignatureAcceptanceValidation
extends AbstractAcceptanceValidation<SignatureWrapper> {
    private final DiagnosticData diagnosticData;

    public SignatureAcceptanceValidation(DiagnosticData diagnosticData, Date currentTime, SignatureWrapper signature, Context context, ValidationPolicy validationPolicy) {
        super(signature, currentTime, context, validationPolicy);
        ((XmlSAV)this.result).setTitle(BasicBuildingBlockDefinition.SIGNATURE_ACCEPTANCE_VALIDATION.getTitle());
        this.diagnosticData = diagnosticData;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlSAV> item = this.firstItem = this.structuralValidation();
        item = item.setNextItem(this.signingTime());
        item = item.setNextItem(this.contentType());
        item = item.setNextItem(this.contentHints());
        item = item.setNextItem(this.messageDigestOrSignedProperties());
        item = item.setNextItem(this.contentIdentifier());
        item = item.setNextItem(this.commitmentTypeIndications());
        item = item.setNextItem(this.signerLocation());
        item = item.setNextItem(this.contentTimestamp());
        item = item.setNextItem(this.countersignature());
        item = item.setNextItem(this.claimedRoles());
        item = item.setNextItem(this.certifiedRoles());
        item = item.setNextItem(this.cryptographic());
    }

    private ChainItem<XmlSAV> structuralValidation() {
        LevelConstraint constraint = this.validationPolicy.getStructuralValidationConstraint(this.context);
        return new StructuralValidationCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signingTime() {
        LevelConstraint constraint = this.validationPolicy.getSigningTimeConstraint();
        return new SigningTimeCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentType() {
        ValueConstraint constraint = this.validationPolicy.getContentTypeConstraint();
        return new ContentTypeCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentHints() {
        ValueConstraint constraint = this.validationPolicy.getContentHintsConstraint();
        return new ContentHintsCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentIdentifier() {
        ValueConstraint constraint = this.validationPolicy.getContentIdentifierConstraint();
        return new ContentIdentifierCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> messageDigestOrSignedProperties() {
        LevelConstraint constraint = this.validationPolicy.getMessageDigestOrSignedPropertiesConstraint();
        return new MessageDigestOrSignedPropertiesCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> commitmentTypeIndications() {
        MultiValuesConstraint constraint = this.validationPolicy.getCommitmentTypeIndicationConstraint();
        return new CommitmentTypeIndicationsCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> signerLocation() {
        LevelConstraint constraint = this.validationPolicy.getSignerLocationConstraint();
        return new SignerLocationCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> contentTimestamp() {
        LevelConstraint constraint = this.validationPolicy.getContentTimestampConstraint();
        return new ContentTimestampCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> countersignature() {
        LevelConstraint constraint = this.validationPolicy.getCounterSignatureConstraint();
        return new CounterSignatureCheck((XmlSAV)this.result, this.diagnosticData, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> claimedRoles() {
        MultiValuesConstraint constraint = this.validationPolicy.getClaimedRoleConstraint();
        return new ClaimedRolesCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }

    private ChainItem<XmlSAV> certifiedRoles() {
        MultiValuesConstraint constraint = this.validationPolicy.getCertifiedRolesConstraint();
        return new CertifiedRolesCheck((XmlSAV)this.result, (SignatureWrapper)this.token, constraint);
    }
}

