/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.isc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValueMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.DigestValuePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.IssuerSerialMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateAttributePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.isc.checks.SigningCertificateRecognitionCheck;
import java.util.List;

public class IdentificationOfTheSigningCertificate
extends Chain<XmlISC> {
    private final TokenProxy token;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public IdentificationOfTheSigningCertificate(TokenProxy token, Context context, ValidationPolicy validationPolicy) {
        super(new XmlISC());
        ((XmlISC)this.result).setTitle(BasicBuildingBlockDefinition.IDENTIFICATION_OF_THE_SIGNING_CERTIFICATE.getTitle());
        this.token = token;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlISC> item = this.firstItem = this.signingCertificateRecognition();
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            SignatureWrapper signature = (SignatureWrapper)this.token;
            if (signature.getSignatureFormat() != null && SignatureForm.PKCS7.equals((Object)signature.getSignatureFormat().getSignatureForm())) {
                return;
            }
            item = item.setNextItem(this.signingCertificateAttributePresent());
            item = item.setNextItem(this.digestValuePresent());
            item = item.setNextItem(this.digestValueMatch());
            item = item.setNextItem(this.issuerSerialMatch());
        }
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        if (this.token.getCertificateChain() != null) {
            XmlCertificateChain certificateChain = new XmlCertificateChain();
            for (CertificateWrapper certificate : this.token.getCertificateChain()) {
                XmlChainItem chainItem = new XmlChainItem();
                chainItem.setId(certificate.getId());
                List<CertificateSourceType> sources = certificate.getSources();
                if (sources.contains((Object)CertificateSourceType.TRUSTED_LIST)) {
                    chainItem.setSource(CertificateSourceType.TRUSTED_LIST);
                } else if (sources.contains((Object)CertificateSourceType.TRUSTED_STORE)) {
                    chainItem.setSource(CertificateSourceType.TRUSTED_STORE);
                } else {
                    chainItem.setSource(sources.iterator().next());
                }
                certificateChain.getChainItem().add(chainItem);
            }
            ((XmlISC)this.result).setCertificateChain(certificateChain);
        }
    }

    private ChainItem<XmlISC> signingCertificateRecognition() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateRecognitionConstraint(this.context);
        return new SigningCertificateRecognitionCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> signingCertificateAttributePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateAttributePresentConstraint(this.context);
        return new SigningCertificateAttributePresentCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValuePresent() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestValuePresentConstraint(this.context);
        return new DigestValuePresentCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> digestValueMatch() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateDigestValueMatchConstraint(this.context);
        return new DigestValueMatchCheck((XmlISC)this.result, this.token, constraint);
    }

    private ChainItem<XmlISC> issuerSerialMatch() {
        LevelConstraint constraint = this.validationPolicy.getSigningCertificateIssuerSerialMatchConstraint(this.context);
        return new IssuerSerialMatchCheck((XmlISC)this.result, this.token, constraint);
    }
}

