/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.IMessageTag;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class FullScopeCheck
extends ChainItem<XmlFC> {
    private final SignatureWrapper signature;

    public FullScopeCheck(XmlFC result, SignatureWrapper signature, LevelConstraint constraint) {
        super(result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        boolean result = true;
        List<XmlSignatureScope> signatureScopes = this.signature.getSignatureScopes();
        for (XmlSignatureScope sigScope : signatureScopes) {
            result &= SignatureScopeType.FULL == sigScope.getScope();
        }
        return result;
    }

    @Override
    protected IMessageTag getMessageTag() {
        return MessageTag.BBB_FC_ICFD;
    }

    @Override
    protected IMessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ICFD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

