/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;

public class ReferenceDataIntactCheck
extends ChainItem<XmlCV> {
    private final XmlDigestMatcher digestMatcher;

    public ReferenceDataIntactCheck(XmlCV result, XmlDigestMatcher digestMatcher, LevelConstraint constraint) {
        super(result, constraint);
        this.digestMatcher = digestMatcher;
    }

    @Override
    protected boolean process() {
        return this.digestMatcher.isDataIntact();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_IRDOI;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_IRDOI_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.HASH_FAILURE;
    }

    @Override
    protected String getAdditionalInfo() {
        if (Utils.isStringNotBlank(this.digestMatcher.getName())) {
            return "Reference : " + this.digestMatcher.getName();
        }
        return this.digestMatcher.getType().name();
    }
}

