/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.cv.CryptographicVerification;
import eu.europa.esig.dss.validation.process.bbb.fc.FormatChecking;
import eu.europa.esig.dss.validation.process.bbb.isc.IdentificationOfTheSigningCertificate;
import eu.europa.esig.dss.validation.process.bbb.sav.AbstractAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.RevocationAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.TimestampAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.vci.ValidationContextInitialization;
import eu.europa.esig.dss.validation.process.bbb.xcv.X509CertificateValidation;
import java.util.Date;
import java.util.List;

public class BasicBuildingBlocks {
    private final DiagnosticData diagnosticData;
    private final TokenProxy token;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final Context context;

    public BasicBuildingBlocks(DiagnosticData diagnosticData, TokenProxy token, Date currentTime, ValidationPolicy policy, Context context) {
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    public XmlBasicBuildingBlocks execute() {
        XmlSAV sav;
        XmlCV cv;
        XmlXCV xcv;
        XmlVCI vci;
        XmlISC isc;
        XmlBasicBuildingBlocks result = new XmlBasicBuildingBlocks();
        result.setId(this.token.getId());
        result.setType(this.context);
        result.setConclusion(new XmlConclusion());
        XmlFC fc = this.executeFormatChecking();
        if (fc != null) {
            result.setFC(fc);
            this.updateFinalConclusion(result, fc);
        }
        if ((isc = this.executeIdentificationOfTheSigningCertificate()) != null) {
            result.setISC(isc);
            result.setCertificateChain(isc.getCertificateChain());
            this.updateFinalConclusion(result, isc);
        }
        if ((vci = this.executeValidationContextInitialization()) != null) {
            result.setVCI(vci);
            this.updateFinalConclusion(result, vci);
        }
        if ((xcv = this.executeX509CertificateValidation()) != null) {
            result.setXCV(xcv);
            this.updateFinalConclusion(result, xcv);
        }
        if ((cv = this.executeCryptographicVerification()) != null) {
            result.setCV(cv);
            this.updateFinalConclusion(result, cv);
        }
        if ((sav = this.executeSignatureAcceptanceValidation()) != null) {
            result.setSAV(sav);
            this.updateFinalConclusion(result, sav);
        }
        if (result.getConclusion().getIndication() == null) {
            result.getConclusion().setIndication(Indication.PASSED);
        }
        return result;
    }

    private void updateFinalConclusion(XmlBasicBuildingBlocks result, XmlConstraintsConclusion constraintsAndConclusion) {
        XmlConclusion finalConclusion = result.getConclusion();
        XmlConclusion currentConclusion = constraintsAndConclusion.getConclusion();
        List<XmlConstraint> constraints = constraintsAndConclusion.getConstraint();
        if (!Indication.PASSED.equals(currentConclusion.getIndication())) {
            finalConclusion.setIndication(currentConclusion.getIndication());
            finalConclusion.setSubIndication(currentConclusion.getSubIndication());
            finalConclusion.getErrors().addAll(currentConclusion.getErrors());
        }
        if (Utils.isCollectionNotEmpty(constraints)) {
            for (XmlConstraint constraint : constraints) {
                XmlName warning;
                XmlName info = constraint.getInfo();
                if (info != null) {
                    finalConclusion.getInfos().add(info);
                }
                if ((warning = constraint.getWarning()) == null) continue;
                finalConclusion.getWarnings().add(warning);
            }
        }
    }

    private XmlFC executeFormatChecking() {
        if (Context.SIGNATURE.equals((Object)this.context)) {
            FormatChecking fc = new FormatChecking(this.diagnosticData, (SignatureWrapper)this.token, this.context, this.policy);
            return (XmlFC)fc.execute();
        }
        return null;
    }

    private XmlISC executeIdentificationOfTheSigningCertificate() {
        if (!Context.CERTIFICATE.equals((Object)this.context)) {
            IdentificationOfTheSigningCertificate isc = new IdentificationOfTheSigningCertificate(this.token, this.context, this.policy);
            return (XmlISC)isc.execute();
        }
        return null;
    }

    private XmlVCI executeValidationContextInitialization() {
        if (Context.SIGNATURE.equals((Object)this.context)) {
            ValidationContextInitialization vci = new ValidationContextInitialization((SignatureWrapper)this.token, this.context, this.policy);
            return (XmlVCI)vci.execute();
        }
        return null;
    }

    private XmlCV executeCryptographicVerification() {
        if (!Context.CERTIFICATE.equals((Object)this.context)) {
            CryptographicVerification cv = new CryptographicVerification(this.diagnosticData, this.token, this.context, this.policy);
            return (XmlCV)cv.execute();
        }
        return null;
    }

    private XmlXCV executeX509CertificateValidation() {
        if (Context.CERTIFICATE.equals((Object)this.context)) {
            CertificateWrapper certificate = (CertificateWrapper)this.token;
            X509CertificateValidation xcv = new X509CertificateValidation(this.diagnosticData, certificate, this.currentTime, certificate.getNotBefore(), this.context, this.policy);
            return (XmlXCV)xcv.execute();
        }
        CertificateWrapper certificate = this.token.getSigningCertificate();
        if (certificate != null) {
            if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
                X509CertificateValidation xcv = new X509CertificateValidation(this.diagnosticData, certificate, this.currentTime, certificate.getNotBefore(), this.context, this.policy);
                return (XmlXCV)xcv.execute();
            }
            if (Context.TIMESTAMP.equals((Object)this.context)) {
                X509CertificateValidation xcv = new X509CertificateValidation(this.diagnosticData, certificate, this.currentTime, ((TimestampWrapper)this.token).getProductionTime(), this.context, this.policy);
                return (XmlXCV)xcv.execute();
            }
            if (Context.REVOCATION.equals((Object)this.context)) {
                X509CertificateValidation xcv = new X509CertificateValidation(this.diagnosticData, certificate, this.currentTime, ((RevocationWrapper)this.token).getProductionDate(), this.context, this.policy);
                return (XmlXCV)xcv.execute();
            }
        }
        return null;
    }

    private XmlSAV executeSignatureAcceptanceValidation() {
        AbstractAcceptanceValidation aav = null;
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            aav = new SignatureAcceptanceValidation(this.diagnosticData, this.currentTime, (SignatureWrapper)this.token, this.context, this.policy);
        } else if (Context.TIMESTAMP.equals((Object)this.context)) {
            aav = new TimestampAcceptanceValidation(this.currentTime, (TimestampWrapper)this.token, this.policy);
        } else if (Context.REVOCATION.equals((Object)this.context)) {
            aav = new RevocationAcceptanceValidation(this.currentTime, (RevocationWrapper)this.token, this.policy);
        }
        return aav != null ? (XmlSAV)aav.execute() : null;
    }
}

