/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import java.util.Arrays;

public class NonASN1SignaturePolicyValidator
extends AbstractSignaturePolicyValidator
implements SignaturePolicyValidator {
    @Override
    public boolean canValidate() {
        SignaturePolicy policy = this.getSignaturePolicy();
        if (policy.getPolicyContent() != null) {
            byte firstByte = DSSUtils.readFirstByte(policy.getPolicyContent());
            return !DSSASN1Utils.isASN1SequenceTag(firstByte);
        }
        return false;
    }

    @Override
    public void validate() {
        this.setIdentified(true);
        SignaturePolicy signaturePolicy = this.getSignaturePolicy();
        Digest digest = signaturePolicy.getDigest();
        byte[] recalculatedDigestValue = DSSUtils.digest(digest.getAlgorithm(), signaturePolicy.getPolicyContent());
        if (Arrays.equals(digest.getValue(), recalculatedDigestValue)) {
            this.setStatus(true);
            this.setDigestAlgorithmsEqual(true);
        } else {
            this.addError("general", "The policy digest value (" + Utils.toBase64(digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64(recalculatedDigestValue) + ").");
        }
    }
}

