/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificate;
import eu.europa.esig.dss.simplereport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.simplereport.jaxb.XmlPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplereport.jaxb.XmlSignatureLevel;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.List;

public class SimpleReportBuilder {
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private int totalSignatureCount = 0;
    private int validSignatureCount = 0;

    public SimpleReportBuilder(Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData, DetailedReport detailedReport) {
        this.currentTime = currentTime;
        this.policy = policy;
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
    }

    public XmlSimpleReport build() {
        XmlSimpleReport simpleReport = new XmlSimpleReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        this.addDocumentName(simpleReport);
        boolean containerInfoPresent = this.diagnosticData.isContainerInfoPresent();
        if (containerInfoPresent) {
            this.addContainerType(simpleReport);
        }
        this.addSignatures(simpleReport, containerInfoPresent);
        this.addStatistics(simpleReport);
        return simpleReport;
    }

    private void addPolicyNode(XmlSimpleReport report) {
        XmlPolicy xmlpolicy = new XmlPolicy();
        xmlpolicy.setPolicyName(this.policy.getPolicyName());
        xmlpolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setPolicy(xmlpolicy);
    }

    private void addValidationTime(XmlSimpleReport report) {
        report.setValidationTime(this.currentTime);
    }

    private void addDocumentName(XmlSimpleReport report) {
        report.setDocumentName(this.diagnosticData.getDocumentName());
    }

    private void addContainerType(XmlSimpleReport simpleReport) {
        simpleReport.setContainerType(this.diagnosticData.getContainerType());
    }

    private void addSignatures(XmlSimpleReport simpleReport, boolean container) {
        this.validSignatureCount = 0;
        this.totalSignatureCount = 0;
        List<SignatureWrapper> signatures = this.diagnosticData.getSignatures();
        for (SignatureWrapper signature : signatures) {
            this.addSignature(simpleReport, signature, container);
        }
    }

    private void addStatistics(XmlSimpleReport simpleReport) {
        simpleReport.setValidSignaturesCount(this.validSignatureCount);
        simpleReport.setSignaturesCount(this.totalSignatureCount);
    }

    private void addSignature(XmlSimpleReport simpleReport, SignatureWrapper signature, boolean container) {
        Indication indication;
        ++this.totalSignatureCount;
        String signatureId = signature.getId();
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setId(signatureId);
        this.addCounterSignature(signature, xmlSignature);
        this.addSignatureScope(signature, xmlSignature);
        this.addSigningTime(signature, xmlSignature);
        this.addBestSignatureTime(signature, xmlSignature);
        this.addSignatureFormat(signature, xmlSignature);
        CertificateWrapper signingCertificate = signature.getSigningCertificate();
        if (signingCertificate != null) {
            xmlSignature.setSignedBy(signingCertificate.getId());
        }
        xmlSignature.getErrors().addAll(this.detailedReport.getErrors(signatureId));
        xmlSignature.getWarnings().addAll(this.detailedReport.getWarnings(signatureId));
        xmlSignature.getInfos().addAll(this.detailedReport.getInfos(signatureId));
        if (container) {
            xmlSignature.setFilename(signature.getSignatureFilename());
        }
        if (Indication.PASSED.equals(indication = this.detailedReport.getHighestIndication(signatureId))) {
            ++this.validSignatureCount;
            xmlSignature.setIndication(Indication.TOTAL_PASSED);
        } else if (Indication.FAILED.equals(indication)) {
            xmlSignature.setIndication(Indication.TOTAL_FAILED);
        } else {
            xmlSignature.setIndication(indication);
        }
        xmlSignature.setSubIndication(this.detailedReport.getHighestSubIndication(signatureId));
        this.addSignatureProfile(xmlSignature);
        List<String> certIds = this.detailedReport.getBasicBuildingBlocksCertChain(signatureId);
        XmlCertificateChain xmlCertificateChain = new XmlCertificateChain();
        if (Utils.isCollectionNotEmpty(certIds)) {
            for (String certid : certIds) {
                XmlCertificate certificate = new XmlCertificate();
                certificate.setId(certid);
                certificate.setQualifiedName(this.getReadableCertificateName(certid));
                xmlCertificateChain.getCertificate().add(certificate);
            }
        }
        xmlSignature.setCertificateChain(xmlCertificateChain);
        simpleReport.getSignature().add(xmlSignature);
    }

    private void addBestSignatureTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setBestSignatureTime(this.detailedReport.getBestSignatureTime(signature.getId()));
    }

    private void addCounterSignature(SignatureWrapper signature, XmlSignature xmlSignature) {
        if (signature.isCounterSignature()) {
            xmlSignature.setCounterSignature(true);
            xmlSignature.setParentId(signature.getParent().getId());
        }
    }

    private void addSignatureScope(SignatureWrapper signature, XmlSignature xmlSignature) {
        List<XmlSignatureScope> signatureScopes = signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (XmlSignatureScope scopeType : signatureScopes) {
                eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope scope = new eu.europa.esig.dss.simplereport.jaxb.XmlSignatureScope();
                scope.setName(scopeType.getName());
                scope.setScope(scopeType.getScope().name());
                scope.setValue(scopeType.getDescription());
                xmlSignature.getSignatureScope().add(scope);
            }
        }
    }

    private void addSigningTime(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSigningTime(signature.getDateTime());
    }

    private void addSignatureFormat(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setSignatureFormat(signature.getSignatureFormat());
    }

    private String getReadableCertificateName(String certId) {
        CertificateWrapper certificateWrapper = this.diagnosticData.getUsedCertificateByIdNullSafe(certId);
        return certificateWrapper.getReadableCertificateName();
    }

    private void addSignatureProfile(XmlSignature xmlSignature) {
        SignatureQualification qualification = this.detailedReport.getSignatureQualification(xmlSignature.getId());
        if (qualification != null) {
            XmlSignatureLevel sigLevel = new XmlSignatureLevel();
            sigLevel.setValue(qualification);
            sigLevel.setDescription(qualification.getLabel());
            xmlSignature.setSignatureLevel(sigLevel);
        }
    }
}

