/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusionWithProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignatures;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.process.qualification.signature.SignatureQualificationBlock;
import eu.europa.esig.dss.validation.process.vpfbs.ValidationProcessForBasicSignatures;
import eu.europa.esig.dss.validation.process.vpfltvd.ValidationProcessForSignaturesWithLongTermValidationData;
import eu.europa.esig.dss.validation.process.vpfswatsp.ValidationProcessForSignaturesWithArchivalData;
import eu.europa.esig.dss.validation.process.vpftsp.ValidationProcessForTimeStamps;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedReportBuilder
extends AbstractDetailedReportBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetailedReportBuilder.class);
    private final ValidationLevel validationLevel;

    public DetailedReportBuilder(Date currentTime, ValidationPolicy policy, ValidationLevel validationLevel, DiagnosticData diagnosticData) {
        super(diagnosticData, policy, currentTime);
        this.validationLevel = validationLevel;
    }

    XmlDetailedReport build() {
        XmlDetailedReport detailedReport = this.init();
        Map<String, XmlBasicBuildingBlocks> bbbs = this.executeAllBasicBuildingBlocks();
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            XmlSignature signatureAnalysis = new XmlSignature();
            signatureAnalysis.setId(signature.getId());
            if (signature.isCounterSignature()) {
                signatureAnalysis.setCounterSignature(true);
            }
            XmlConstraintsConclusionWithProofOfExistence validation = this.executeBasicValidation(signatureAnalysis, signature, bbbs);
            if (ValidationLevel.TIMESTAMPS.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.LONG_TERM_DATA.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
                validation = this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
            } else if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
                this.executeTimestampsValidation(signatureAnalysis, signature, bbbs);
                this.executeLongTermValidation(signatureAnalysis, signature, bbbs);
                validation = this.executeArchiveValidation(signatureAnalysis, signature, bbbs);
            }
            if (this.policy.isEIDASConstraintPresent()) {
                try {
                    CertificateWrapper signingCertificate = signature.getSigningCertificate();
                    if (signingCertificate != null) {
                        SignatureQualificationBlock qualificationBlock = new SignatureQualificationBlock(signature.getId(), validation, signingCertificate, detailedReport.getTLAnalysis(), this.diagnosticData.getLOTLCountryCode());
                        signatureAnalysis.setValidationSignatureQualification((XmlValidationSignatureQualification)qualificationBlock.execute());
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to determine the signature qualification", e);
                }
            }
            detailedReport.getSignatures().add(signatureAnalysis);
        }
        return detailedReport;
    }

    private XmlValidationProcessBasicSignatures executeBasicValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForBasicSignatures vpfbs = new ValidationProcessForBasicSignatures(this.diagnosticData, signature, bbbs);
        XmlValidationProcessBasicSignatures bs = (XmlValidationProcessBasicSignatures)vpfbs.execute();
        signatureAnalysis.setValidationProcessBasicSignatures(bs);
        return bs;
    }

    private void executeTimestampsValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        List<TimestampWrapper> allTimestamps = signature.getTimestampList();
        for (TimestampWrapper timestamp : allTimestamps) {
            ValidationProcessForTimeStamps vpftsp = new ValidationProcessForTimeStamps(timestamp, bbbs);
            signatureAnalysis.getValidationProcessTimestamps().add((XmlValidationProcessTimestamps)vpftsp.execute());
        }
    }

    private XmlValidationProcessLongTermData executeLongTermValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithLongTermValidationData vpfltvd = new ValidationProcessForSignaturesWithLongTermValidationData(signatureAnalysis, this.diagnosticData, signature, bbbs, this.policy, this.currentTime);
        XmlValidationProcessLongTermData vpfltvdResult = (XmlValidationProcessLongTermData)vpfltvd.execute();
        signatureAnalysis.setValidationProcessLongTermData(vpfltvdResult);
        return vpfltvdResult;
    }

    private XmlValidationProcessArchivalData executeArchiveValidation(XmlSignature signatureAnalysis, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs) {
        ValidationProcessForSignaturesWithArchivalData vpfswad = new ValidationProcessForSignaturesWithArchivalData(signatureAnalysis, signature, this.diagnosticData, bbbs, this.policy, this.currentTime);
        XmlValidationProcessArchivalData vpfswadResult = (XmlValidationProcessArchivalData)vpfswad.execute();
        signatureAnalysis.setValidationProcessArchivalData(vpfswadResult);
        return vpfswadResult;
    }

    private Map<String, XmlBasicBuildingBlocks> executeAllBasicBuildingBlocks() {
        LinkedHashMap<String, XmlBasicBuildingBlocks> bbbs = new LinkedHashMap<String, XmlBasicBuildingBlocks>();
        switch (this.validationLevel) {
            case ARCHIVAL_DATA: 
            case LONG_TERM_DATA: {
                this.process(this.diagnosticData.getAllRevocationData(), Context.REVOCATION, bbbs);
                this.process(this.diagnosticData.getTimestampList(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case TIMESTAMPS: {
                this.process(this.diagnosticData.getTimestampList(), Context.TIMESTAMP, bbbs);
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            case BASIC_SIGNATURES: {
                this.process(this.diagnosticData.getAllSignatures(), Context.SIGNATURE, bbbs);
                this.process(this.diagnosticData.getAllCounterSignatures(), Context.COUNTER_SIGNATURE, bbbs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation level " + (Object)((Object)this.validationLevel));
            }
        }
        return bbbs;
    }
}

