/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.validation.executor.DetailedReportBuilder;
import eu.europa.esig.dss.validation.executor.ETSIValidationReportBuilder;
import eu.europa.esig.dss.validation.executor.SignatureProcessExecutor;
import eu.europa.esig.dss.validation.executor.SimpleReportBuilder;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import java.util.Date;
import java.util.Objects;

public class DefaultSignatureProcessExecutor
implements SignatureProcessExecutor {
    private Date currentTime = new Date();
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private boolean enableEtsiValidationReport = true;
    private XmlDiagnosticData jaxbDiagnosticData;
    private ValidationPolicy policy;

    @Override
    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public void setDiagnosticData(XmlDiagnosticData diagnosticData) {
        this.jaxbDiagnosticData = diagnosticData;
    }

    @Override
    public void setValidationPolicy(ValidationPolicy policy) {
        this.policy = policy;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public Reports execute() {
        Objects.requireNonNull(this.jaxbDiagnosticData, "The diagnostic data is missing");
        Objects.requireNonNull(this.policy, "The validation policy is missing");
        Objects.requireNonNull(this.currentTime, "The current time is missing");
        Objects.requireNonNull(this.validationLevel, "The validation level is missing");
        DiagnosticData diagnosticData = new DiagnosticData(this.jaxbDiagnosticData);
        DetailedReportBuilder detailedReportBuilder = new DetailedReportBuilder(this.currentTime, this.policy, this.validationLevel, diagnosticData);
        XmlDetailedReport jaxbDetailedReport = detailedReportBuilder.build();
        DetailedReport detailedReportWrapper = new DetailedReport(jaxbDetailedReport);
        SimpleReportBuilder simpleReportBuilder = new SimpleReportBuilder(this.currentTime, this.policy, diagnosticData, detailedReportWrapper);
        XmlSimpleReport simpleReport = simpleReportBuilder.build();
        ValidationReportType validationReport = null;
        if (this.enableEtsiValidationReport) {
            ETSIValidationReportBuilder etsiValidationReportBuilder = new ETSIValidationReportBuilder(this.currentTime, diagnosticData, detailedReportWrapper);
            validationReport = etsiValidationReportBuilder.build();
        }
        return new Reports(this.jaxbDiagnosticData, jaxbDetailedReport, simpleReport, validationReport);
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public ValidationPolicy getValidationPolicy() {
        return this.policy;
    }
}

