/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.IssuerSerialInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureCertificateSource
extends CommonCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureCertificateSource.class);
    private List<CertificateRef> certificateRefs;
    private transient Map<CertificateToken, List<CertificateRef>> certificateRefsMap;
    private List<CertificateRef> orphanCertificateRefs;

    protected SignatureCertificateSource(CertificatePool certPool) {
        super(certPool);
    }

    public abstract List<CertificateToken> getKeyInfoCertificates();

    public abstract List<CertificateToken> getCertificateValues();

    public abstract List<CertificateToken> getAttrAuthoritiesCertValues();

    public abstract List<CertificateToken> getTimeStampValidationDataCertValues();

    public List<CertificateToken> getDSSDictionaryCertValues() {
        return Collections.emptyList();
    }

    public List<CertificateToken> getVRIDictionaryCertValues() {
        return Collections.emptyList();
    }

    public abstract List<CertificateRef> getSigningCertificateValues();

    public List<CertificateToken> getSigningCertificates() {
        return this.findTokensFromRefs(this.getSigningCertificateValues());
    }

    public abstract List<CertificateRef> getCompleteCertificateRefs();

    public List<CertificateToken> getCompleteCertificates() {
        return this.findTokensFromRefs(this.getCompleteCertificateRefs());
    }

    public abstract List<CertificateRef> getAttributeCertificateRefs();

    public List<CertificateToken> getAttributeCertificates() {
        return this.findTokensFromRefs(this.getAttributeCertificateRefs());
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.SIGNATURE;
    }

    public List<CertificateRef> getReferencesForCertificateToken(CertificateToken certificateToken) {
        List<CertificateRef> references;
        if (Utils.isMapEmpty(this.certificateRefsMap)) {
            this.collectCertificateRefsMap();
        }
        if ((references = this.certificateRefsMap.get(certificateToken)) != null) {
            return references;
        }
        return Collections.emptyList();
    }

    public List<CertificateToken> findTokensFromRefs(List<CertificateRef> certificateRefs) {
        if (Utils.isMapEmpty(this.certificateRefsMap)) {
            this.collectCertificateRefsMap();
        }
        ArrayList<CertificateToken> tokensFromRefs = new ArrayList<CertificateToken>();
        block0: for (Map.Entry<CertificateToken, List<CertificateRef>> certMapEntry : this.certificateRefsMap.entrySet()) {
            for (CertificateRef reference : certMapEntry.getValue()) {
                if (!certificateRefs.contains(reference)) continue;
                tokensFromRefs.add(certMapEntry.getKey());
                continue block0;
            }
        }
        return tokensFromRefs;
    }

    public List<CertificateRef> getAllCertificateRefs() {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList<CertificateRef>();
            this.certificateRefs.addAll(this.getCompleteCertificateRefs());
            this.certificateRefs.addAll(this.getAttributeCertificateRefs());
            this.certificateRefs.addAll(this.getSigningCertificateValues());
        }
        return this.certificateRefs;
    }

    public CertificateRef getCertificateRefByDigest(Digest digest) {
        for (CertificateRef certificateRef : this.getAllCertificateRefs()) {
            if (!digest.equals(certificateRef.getCertDigest())) continue;
            return certificateRef;
        }
        return null;
    }

    private void collectCertificateRefsMap() {
        this.certificateRefsMap = new HashMap<CertificateToken, List<CertificateRef>>();
        for (CertificateToken certificateToken : this.getCertificates()) {
            for (CertificateRef certificateRef : this.getAllCertificateRefs()) {
                Digest certDigest = certificateRef.getCertDigest();
                IssuerSerialInfo issuerInfo = certificateRef.getIssuerInfo();
                if (certDigest != null) {
                    byte[] currentDigest = certificateToken.getDigest(certDigest.getAlgorithm());
                    if (!Arrays.equals(currentDigest, certDigest.getValue())) continue;
                    this.addCertificateRefToMap(certificateToken, certificateRef);
                    continue;
                }
                if (issuerInfo == null || !certificateToken.getSerialNumber().equals(issuerInfo.getSerialNumber()) || !DSSUtils.x500PrincipalAreEquals(certificateToken.getIssuerX500Principal(), issuerInfo.getIssuerName())) continue;
                this.addCertificateRefToMap(certificateToken, certificateRef);
            }
        }
    }

    private void addCertificateRefToMap(CertificateToken certificateToken, CertificateRef certificateRef) {
        List<CertificateRef> certificateRefs = this.certificateRefsMap.get(certificateToken);
        if (certificateRefs == null) {
            certificateRefs = new ArrayList<CertificateRef>();
            this.certificateRefsMap.put(certificateToken, certificateRefs);
        }
        certificateRefs.add(certificateRef);
    }

    public List<CertificateRef> getOrphanCertificateRefs() {
        if (this.orphanCertificateRefs == null) {
            this.orphanCertificateRefs = new ArrayList<CertificateRef>();
            if (Utils.isMapEmpty(this.certificateRefsMap)) {
                this.collectCertificateRefsMap();
            }
            for (CertificateRef certificateRef : this.getAllCertificateRefs()) {
                boolean found = false;
                for (List<CertificateRef> assignedCertificateRefs : this.certificateRefsMap.values()) {
                    if (!assignedCertificateRefs.contains(certificateRef)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.orphanCertificateRefs.add(certificateRef);
            }
        }
        return this.orphanCertificateRefs;
    }

    protected IssuerSerialInfo getIssuerInfo(IssuerSerial issuerAndSerial) {
        try {
            ASN1Integer serialNumber;
            IssuerSerialInfo issuerInfo = new IssuerSerialInfo();
            GeneralNames gnames = issuerAndSerial.getIssuer();
            if (gnames != null) {
                GeneralName[] names = gnames.getNames();
                if (names.length == 1) {
                    issuerInfo.setIssuerName(new X500Principal(names[0].getName().toASN1Primitive().getEncoded("DER")));
                } else {
                    LOG.warn("More than one GeneralName");
                }
            }
            if ((serialNumber = issuerAndSerial.getSerial()) != null) {
                issuerInfo.setSerialNumber(serialNumber.getValue());
            }
            return issuerInfo;
        }
        catch (Exception e) {
            LOG.error("Unable to read the IssuerSerial object", e);
            return null;
        }
    }
}

