/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureRevocationSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SignatureCRLSource
extends OfflineCRLSource
implements SignatureRevocationSource<CRLToken> {
    private Map<CRLBinary, List<CRLToken>> crlTokenMap = new HashMap<CRLBinary, List<CRLToken>>();
    private List<CRLToken> revocationValuesCRLs = new ArrayList<CRLToken>();
    private List<CRLToken> attributeRevocationValuesCRLs = new ArrayList<CRLToken>();
    private List<CRLToken> timestampValidationDataCRLs = new ArrayList<CRLToken>();
    private List<CRLToken> dssDictionaryCRLs = new ArrayList<CRLToken>();
    private List<CRLToken> vriDictionaryCRLs = new ArrayList<CRLToken>();
    private List<CRLToken> timestampRevocationValuesCRLs = new ArrayList<CRLToken>();
    private List<CRLRef> crlRefs = new ArrayList<CRLRef>();
    private List<CRLRef> orphanRevocationRefsCRLs;
    private transient Map<CRLToken, Set<CRLRef>> revocationRefsMap;

    @Override
    public List<CRLToken> getRevocationValuesTokens() {
        return this.revocationValuesCRLs;
    }

    @Override
    public List<CRLToken> getAttributeRevocationValuesTokens() {
        return this.attributeRevocationValuesCRLs;
    }

    @Override
    public List<CRLToken> getTimestampValidationDataTokens() {
        return this.timestampValidationDataCRLs;
    }

    @Override
    public List<CRLToken> getTimestampRevocationValuesTokens() {
        return this.timestampRevocationValuesCRLs;
    }

    @Override
    public List<CRLToken> getDSSDictionaryTokens() {
        return this.dssDictionaryCRLs;
    }

    @Override
    public List<CRLToken> getVRIDictionaryTokens() {
        return this.vriDictionaryCRLs;
    }

    public List<CRLRef> getCompleteRevocationRefs() {
        return this.getCRLRefsByOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
    }

    public List<CRLRef> getAttributeRevocationRefs() {
        return this.getCRLRefsByOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    public List<CRLRef> getTimestampRevocationRefs() {
        return this.getCRLRefsByOrigin(RevocationRefOrigin.TIMESTAMP_REVOCATION_REFS);
    }

    private List<CRLRef> getCRLRefsByOrigin(RevocationRefOrigin origin) {
        ArrayList<CRLRef> revocationRefsCRLs = new ArrayList<CRLRef>();
        for (CRLRef crlRef : this.crlRefs) {
            if (!crlRef.getOrigins().contains((Object)origin)) continue;
            revocationRefsCRLs.add(crlRef);
        }
        return revocationRefsCRLs;
    }

    public List<CRLToken> getAllCRLTokens() {
        ArrayList<CRLToken> crlTokens = new ArrayList<CRLToken>();
        crlTokens.addAll(this.getRevocationValuesTokens());
        crlTokens.addAll(this.getAttributeRevocationValuesTokens());
        crlTokens.addAll(this.getTimestampValidationDataTokens());
        crlTokens.addAll(this.getDSSDictionaryTokens());
        crlTokens.addAll(this.getVRIDictionaryTokens());
        crlTokens.addAll(this.getTimestampRevocationValuesTokens());
        return crlTokens;
    }

    public List<CRLRef> getAllCRLReferences() {
        return this.crlRefs;
    }

    public Map<CRLBinary, List<CRLToken>> getCRLTokenMap() {
        return this.crlTokenMap;
    }

    public void populateCRLRevocationValues(SignatureCRLSource signatureCRLSource) {
        for (Map.Entry<CRLBinary, List<CRLToken>> entry : signatureCRLSource.getCRLTokenMap().entrySet()) {
            for (CRLToken crlToken : entry.getValue()) {
                this.storeCRLToken(entry.getKey(), crlToken);
            }
        }
    }

    @Override
    protected void storeCRLToken(CRLBinary crlBinary, CRLToken crlToken) {
        if (this.getCRLBinaryList().contains(crlBinary)) {
            List<CRLToken> tokensList = this.crlTokenMap.get(crlBinary);
            if (tokensList == null) {
                tokensList = new ArrayList<CRLToken>();
                this.crlTokenMap.put(crlBinary, tokensList);
            }
            tokensList.add(crlToken);
            for (RevocationOrigin origin : this.getRevocationOrigins(crlBinary)) {
                this.addToRelevantList(crlToken, origin);
            }
        }
    }

    private void addToRelevantList(CRLToken crlToken, RevocationOrigin origin) {
        switch (origin) {
            case REVOCATION_VALUES: {
                this.revocationValuesCRLs.add(crlToken);
                break;
            }
            case ATTRIBUTE_REVOCATION_VALUES: {
                this.attributeRevocationValuesCRLs.add(crlToken);
                break;
            }
            case TIMESTAMP_VALIDATION_DATA: {
                this.timestampValidationDataCRLs.add(crlToken);
                break;
            }
            case DSS_DICTIONARY: {
                this.dssDictionaryCRLs.add(crlToken);
                break;
            }
            case VRI_DICTIONARY: {
                this.vriDictionaryCRLs.add(crlToken);
                break;
            }
            case TIMESTAMP_REVOCATION_VALUES: {
                this.timestampRevocationValuesCRLs.add(crlToken);
                break;
            }
            default: {
                throw new DSSException(String.format("The given RevocationOrigin [%s] is not supported for CRLToken object in the SignatureCRLSource", new Object[]{origin}));
            }
        }
    }

    protected void addReference(CRLRef crlRef) {
        for (RevocationRefOrigin origin : crlRef.getOrigins()) {
            this.addReference(crlRef, origin);
        }
    }

    protected void addReference(CRLRef crlRef, RevocationRefOrigin origin) {
        int index = this.crlRefs.indexOf(crlRef);
        if (index == -1) {
            this.crlRefs.add(crlRef);
        } else {
            CRLRef storedCRLRef = this.crlRefs.get(index);
            storedCRLRef.addOrigin(origin);
        }
    }

    public List<CRLRef> getReferencesForCRLIdentifier(CRLBinary crlBinary) {
        ArrayList<CRLRef> relatedRefs = new ArrayList<CRLRef>();
        for (CRLRef crlRef : this.getAllCRLReferences()) {
            byte[] digestValue = crlBinary.getDigestValue(crlRef.getDigest().getAlgorithm());
            if (!Arrays.equals(crlRef.getDigest().getValue(), digestValue)) continue;
            relatedRefs.add(crlRef);
        }
        return relatedRefs;
    }

    public CRLRef getCRLRefByDigest(Digest digest) {
        for (CRLRef crlRef : this.getAllCRLReferences()) {
            if (!digest.equals(crlRef.getDigest())) continue;
            return crlRef;
        }
        return null;
    }

    public List<CRLRef> getOrphanCrlRefs() {
        if (this.orphanRevocationRefsCRLs == null) {
            this.orphanRevocationRefsCRLs = new ArrayList<CRLRef>();
            for (CRLRef crlRef : this.getAllCRLReferences()) {
                if (this.getIdentifier(crlRef) != null) continue;
                this.orphanRevocationRefsCRLs.add(crlRef);
            }
        }
        return this.orphanRevocationRefsCRLs;
    }

    public List<CRLToken> findTokensFromRefs(List<CRLRef> revocationRefs) {
        if (Utils.isMapEmpty(this.revocationRefsMap)) {
            this.collectRevocationRefsMap();
        }
        ArrayList<CRLToken> tokensFromRefs = new ArrayList<CRLToken>();
        block0: for (Map.Entry<CRLToken, Set<CRLRef>> revocationMapEntry : this.revocationRefsMap.entrySet()) {
            for (CRLRef tokenRevocationRef : revocationMapEntry.getValue()) {
                if (!revocationRefs.contains(tokenRevocationRef)) continue;
                tokensFromRefs.add(revocationMapEntry.getKey());
                continue block0;
            }
        }
        return tokensFromRefs;
    }

    public Set<CRLRef> findRefsForRevocationToken(CRLToken revocationToken) {
        Set<CRLRef> revocationRefs;
        if (Utils.isMapEmpty(this.revocationRefsMap)) {
            this.collectRevocationRefsMap();
        }
        if ((revocationRefs = this.revocationRefsMap.get(revocationToken)) != null) {
            return revocationRefs;
        }
        return Collections.emptySet();
    }

    private void collectRevocationRefsMap() {
        this.revocationRefsMap = new HashMap<CRLToken, Set<CRLRef>>();
        for (CRLToken revocationToken : this.getAllCRLTokens()) {
            for (CRLRef reference : this.getAllCRLReferences()) {
                if (!Arrays.equals(reference.getDigest().getValue(), revocationToken.getDigest(reference.getDigest().getAlgorithm()))) continue;
                this.addReferenceToMap(revocationToken, reference);
            }
        }
    }

    private void addReferenceToMap(CRLToken revocationToken, CRLRef reference) {
        Set<CRLRef> crlRefs = this.revocationRefsMap.get(revocationToken);
        if (crlRefs == null) {
            crlRefs = new HashSet<CRLRef>();
            this.revocationRefsMap.put(revocationToken, crlRefs);
        }
        crlRefs.add(reference);
    }
}

