/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.validation.SignatureCRLSource;

public class ListCRLSource
extends SignatureCRLSource {
    public ListCRLSource() {
    }

    public ListCRLSource(OfflineCRLSource crlSource) {
        this.addAll(crlSource);
    }

    public void addAll(OfflineCRLSource offlineCRLSource) {
        for (CRLBinary crlBinary : offlineCRLSource.getCRLBinaryList()) {
            for (RevocationOrigin origin : offlineCRLSource.getRevocationOrigins(crlBinary)) {
                this.addCRLBinary(crlBinary, origin);
            }
        }
        if (offlineCRLSource instanceof SignatureCRLSource) {
            SignatureCRLSource signatureCRLSource = (SignatureCRLSource)offlineCRLSource;
            for (CRLRef crlRef : signatureCRLSource.getAllCRLReferences()) {
                this.addReference(crlRef);
            }
        }
    }
}

