/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListCRLSource;
import eu.europa.esig.dss.validation.ListOCSPSource;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.OCSPAndCRLCertificateVerifier;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAdvancedSignature
implements AdvancedSignature {
    private static final long serialVersionUID = 6452189007886779360L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAdvancedSignature.class);
    protected final CertificatePool certPool;
    protected CertificateToken providedSigningCertificateToken;
    protected List<DSSDocument> detachedContents;
    private List<DSSDocument> containerContents;
    protected List<ManifestFile> manifestFiles;
    protected List<ReferenceValidation> referenceValidations;
    protected SignatureCryptographicVerification signatureCryptographicVerification;
    protected String structureValidation;
    protected CandidatesForSigningCertificate candidatesForSigningCertificate;
    protected SignatureCertificateSource offlineCertificateSource;
    protected SignatureCRLSource signatureCRLSource;
    protected SignatureOCSPSource signatureOCSPSource;
    protected SignatureTimestampSource signatureTimestampSource;
    private AdvancedSignature masterSignature;
    protected SignaturePolicy signaturePolicy;
    private List<SignatureScope> signatureScopes;
    private String signatureFilename;
    protected SignatureIdentifier signatureIdentifier;

    protected abstract SignatureIdentifier buildSignatureIdentifier();

    protected DefaultAdvancedSignature(CertificatePool certPool) {
        this.certPool = certPool;
    }

    @Override
    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    @Override
    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public List<DSSDocument> getContainerContents() {
        return this.containerContents;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFiles(List<ManifestFile> manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    @Override
    public List<CertificateRef> getOrphanCertificateRefs() {
        return this.getCertificateSource().getOrphanCertificateRefs();
    }

    @Override
    public SignatureIdentifier getDSSId() {
        if (this.signatureIdentifier == null) {
            this.signatureIdentifier = this.buildSignatureIdentifier();
        }
        return this.signatureIdentifier;
    }

    @Override
    public String getId() {
        return "S-" + this.getDSSId().asXmlId();
    }

    @Override
    public List<DSSDocument> getManifestedDocuments() {
        ArrayList<DSSDocument> foundManifestedDocuments = new ArrayList<DSSDocument>();
        if (Utils.isCollectionEmpty(this.manifestFiles) || Utils.isCollectionEmpty(this.containerContents)) {
            return foundManifestedDocuments;
        }
        for (ManifestFile manifestFile : this.manifestFiles) {
            if (!manifestFile.getSignatureFilename().equals(this.signatureFilename)) continue;
            for (DSSDocument document : this.containerContents) {
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    if (!entry.getFileName().equals(document.getName())) continue;
                    foundManifestedDocuments.add(document);
                }
            }
        }
        return foundManifestedDocuments;
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        SignatureLevel[] signatureLevels = this.getSignatureLevels();
        SignatureLevel dataFoundUpToProfile = this.getDataFoundUpToProfile(signatureLevels);
        return dataFoundUpToProfile;
    }

    @Override
    public ListCRLSource getCompleteCRLSource() {
        return this.getTimestampSource().getCommonCRLSource();
    }

    @Override
    public ListOCSPSource getCompleteOCSPSource() {
        return this.getTimestampSource().getCommonOCSPSource();
    }

    private SignatureLevel getDataFoundUpToProfile(SignatureLevel ... signatureLevels) {
        for (int ii = signatureLevels.length - 1; ii >= 0; --ii) {
            SignatureLevel signatureLevel = signatureLevels[ii];
            if (!this.isDataForSignatureLevelPresent(signatureLevel)) continue;
            return signatureLevel;
        }
        return null;
    }

    public ValidationContext getSignatureValidationContext(CertificateVerifier certificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext(this.certPool);
        certificateVerifier.setSignatureCRLSource(this.getCompleteCRLSource());
        certificateVerifier.setSignatureOCSPSource(this.getCompleteOCSPSource());
        validationContext.initialize(certificateVerifier);
        if (this.providedSigningCertificateToken != null) {
            validationContext.addCertificateTokenForVerification(this.providedSigningCertificateToken);
        }
        List<CertificateToken> certificates = this.getCertificates();
        for (CertificateToken certificate : certificates) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        this.prepareTimestamps(validationContext);
        validationContext.validate();
        this.checkTimestamp(certificateVerifier, validationContext);
        this.checkAllRevocationDataPresent(certificateVerifier, validationContext);
        this.checkAllTimestampCoveredByRevocationData(certificateVerifier, validationContext);
        this.checkAllCertificateNotRevoked(certificateVerifier, validationContext);
        this.checkRevocationThisUpdateIsAfterBestSignatureTime(certificateVerifier, validationContext);
        return validationContext;
    }

    private void checkTimestamp(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllTimestampValid()) {
            String message = "Broken timestamp detected";
            if (certificateVerifier.isExceptionOnInvalidTimestamp()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkAllRevocationDataPresent(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllRequiredRevocationDataPresent()) {
            String message = "Revocation data is missing";
            if (certificateVerifier.isExceptionOnMissingRevocationData()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkAllTimestampCoveredByRevocationData(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllPOECoveredByRevocationData()) {
            String message = "A POE is not covered by an usable revocation data";
            if (certificateVerifier.isExceptionOnUncoveredPOE()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkAllCertificateNotRevoked(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAllCertificateValid()) {
            String message = "Revoked certificate detected";
            if (certificateVerifier.isExceptionOnRevokedCertificate()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    private void checkRevocationThisUpdateIsAfterBestSignatureTime(CertificateVerifier certificateVerifier, ValidationContext validationContext) {
        if (!validationContext.isAtLeastOneRevocationDataPresentAfterBestSignatureTime(this.getSigningCertificateToken())) {
            String message = "Revocation data thisUpdate time is after the bestSignatureTime";
            if (certificateVerifier.isExceptionOnNoRevocationAfterBestSignatureTime()) {
                throw new DSSException(message);
            }
            LOG.warn(message);
        }
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.getCertificateSource().getCertificates();
    }

    public List<CertificateToken> getTimestampSourceCertificates() {
        return this.getTimestampSource().getCertificates();
    }

    public Set<CertificateToken> getCertificatesForInclusion(ValidationContext validationContext) {
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        List<CertificateToken> certWithinSignatures = this.getCertificateListWithinSignatureAndTimestamps();
        for (CertificateToken certificateToken : validationContext.getProcessedCertificates()) {
            if (certWithinSignatures.contains(certificateToken)) continue;
            certificates.add(certificateToken);
        }
        return certificates;
    }

    @Override
    public List<CertificateToken> getCertificateListWithinSignatureAndTimestamps() {
        ArrayList<CertificateToken> certs = new ArrayList<CertificateToken>(this.getCertificates());
        for (CertificateToken token : this.getTimestampSourceCertificates()) {
            if (certs.contains(token)) continue;
            certs.add(token);
        }
        return certs;
    }

    public Map<String, List<CertificateToken>> getCertificateMapWithinSignatureAndTimestamps(boolean skipLastArchiveTimestamp) {
        HashMap<String, List<CertificateToken>> certificateMap = new HashMap<String, List<CertificateToken>>();
        List<CertificateToken> certificatesSig = this.getCertificateSource().getCertificates();
        if (Utils.isCollectionNotEmpty(certificatesSig)) {
            certificateMap.put(CertificateSourceType.SIGNATURE.name(), certificatesSig);
        }
        certificateMap.putAll(this.getTimestampSource().getCertificateMapWithinTimestamps(skipLastArchiveTimestamp));
        return certificateMap;
    }

    public RevocationDataForInclusion getRevocationDataForInclusion(ValidationContext validationContext) {
        Set<RevocationToken> revocationTokens = validationContext.getProcessedRevocations();
        ArrayList<CRLToken> crlTokens = new ArrayList<CRLToken>();
        ArrayList<OCSPToken> ocspTokens = new ArrayList<OCSPToken>();
        ArrayList<TokenIdentifier> revocationIds = new ArrayList<TokenIdentifier>();
        for (RevocationToken revocationToken : revocationTokens) {
            if (revocationIds.contains(revocationToken.getDSSId())) continue;
            revocationIds.add(revocationToken.getDSSId());
            if (revocationToken instanceof CRLToken) {
                CRLToken crlToken = (CRLToken)revocationToken;
                crlTokens.add(crlToken);
                continue;
            }
            if (revocationToken instanceof OCSPToken) {
                OCSPToken ocspToken = (OCSPToken)revocationToken;
                ocspTokens.add(ocspToken);
                continue;
            }
            throw new DSSException("Unknown type for revocationToken: " + revocationToken.getClass().getName());
        }
        return new RevocationDataForInclusion(crlTokens, ocspTokens);
    }

    @Override
    public void setMasterSignature(AdvancedSignature masterSignature) {
        this.masterSignature = masterSignature;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        return this.masterSignature;
    }

    @Override
    public SignatureCryptographicVerification getSignatureCryptographicVerification() {
        if (this.signatureCryptographicVerification == null) {
            this.checkSignatureIntegrity();
        }
        return this.signatureCryptographicVerification;
    }

    @Override
    public List<SignerRole> getSignerRoles() {
        List<SignerRole> signerRoles = this.getClaimedSignerRoles();
        signerRoles.addAll(this.getCertifiedSignerRoles());
        return signerRoles;
    }

    @Override
    public CertificateToken getProvidedSigningCertificateToken() {
        return this.providedSigningCertificateToken;
    }

    @Override
    public void setProvidedSigningCertificateToken(CertificateToken certificateToken) {
        this.providedSigningCertificateToken = certificateToken;
    }

    @Override
    public CertificateToken getSigningCertificateToken() {
        this.candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
        this.checkSignatureIntegrity();
        this.signatureCryptographicVerification = this.getSignatureCryptographicVerification();
        CertificateValidity theCertificateValidity = this.candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null && theCertificateValidity.isValid()) {
            CertificateToken signingCertificateToken = theCertificateValidity.getCertificateToken();
            return signingCertificateToken;
        }
        CertificateValidity theBestCandidate = this.candidatesForSigningCertificate.getTheBestCandidate();
        return theBestCandidate == null ? null : theBestCandidate.getCertificateToken();
    }

    @Override
    public void prepareTimestamps(ValidationContext validationContext) {
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    @Override
    public void validateStructure() {
    }

    @Override
    public String getStructureValidationResult() {
        return this.structureValidation;
    }

    protected List<TimestampedReference> getContentTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(this.signatureScopes)) {
            for (SignatureScope signatureScope : this.signatureScopes) {
                this.addReference(references, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return references;
    }

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReferences(references, this.getContentTimestampReferences());
        this.addReference(references, new TimestampedReference(this.getId(), TimestampedObjectType.SIGNATURE));
        this.addReferences(references, this.getSigningCertificateTimestampReferences());
        return references;
    }

    protected List<TimestampedReference> getSigningCertificateTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List<CertificateToken> signingCertificates = this.getCertificateSource().getSigningCertificates();
        for (CertificateToken certificateToken : signingCertificates) {
            this.addReference(references, new TimestampedReference(certificateToken.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return references;
    }

    protected void addReferencesForPreviousTimestamps(List<TimestampedReference> references, List<TimestampToken> timestampedTimestamps) {
        for (TimestampToken timestampToken : timestampedTimestamps) {
            this.addReference(references, new TimestampedReference(timestampToken.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
            this.addEncapsulatedCertificatesFromTimestamp(references, timestampToken);
        }
    }

    protected void addEncapsulatedCertificatesFromTimestamp(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        List<CertificateToken> certificates = timestampedTimestamp.getCertificates();
        for (CertificateToken certificate : certificates) {
            this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
    }

    protected void addReferencesForCertificates(List<TimestampedReference> references) {
        List<CertificateToken> certValues = this.getCertificateSource().getCertificateValues();
        for (CertificateToken certificate : certValues) {
            this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        List<CertificateToken> completeCertValues = this.getCertificateSource().getCompleteCertificates();
        for (CertificateToken certificate : completeCertValues) {
            this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
    }

    protected List<TimestampedReference> getTimestampedReferencesFromCertificates(List<CertificateToken> certificateTokens) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : certificateTokens) {
            timestampedReferences.add(new TimestampedReference(certificateToken.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected void addReferencesFromRevocationData(List<TimestampedReference> references) {
        List<RevocationToken> completeRevocationTokens = this.getCompleteRevocationTokens();
        for (RevocationToken revocationToken : completeRevocationTokens) {
            this.addReference(references, new TimestampedReference(revocationToken.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
    }

    protected void addReference(List<TimestampedReference> referenceList, TimestampedReference referenceToAdd) {
        this.addReferences(referenceList, Arrays.asList(referenceToAdd));
    }

    protected void addReferences(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToAdd) {
        for (TimestampedReference reference : referencesToAdd) {
            if (referenceList.contains(reference)) continue;
            referenceList.add(reference);
        }
    }

    @Override
    public SignaturePolicy getPolicyId() {
        return this.signaturePolicy;
    }

    @Override
    public void populateCRLTokenLists(SignatureCRLSource crlSource) {
        this.getCRLSource().populateCRLRevocationValues(crlSource);
        this.getCompleteCRLSource().populateCRLRevocationValues(crlSource);
    }

    @Override
    public void populateOCSPTokenLists(SignatureOCSPSource ocspSource) {
        this.getOCSPSource().populateOCSPRevocationTokenLists(ocspSource);
        this.getCompleteOCSPSource().populateOCSPRevocationTokenLists(ocspSource);
    }

    @Override
    public void findSignatureScope(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopes = signatureScopeFinder.findSignatureScope(this);
    }

    @Override
    public List<SignatureScope> getSignatureScopes() {
        return this.signatureScopes;
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        return this.getTimestampSource().getContentTimestamps();
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        return this.getTimestampSource().getSignatureTimestamps();
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        return this.getTimestampSource().getTimestampsX1();
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        return this.getTimestampSource().getTimestampsX2();
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        return this.getTimestampSource().getArchiveTimestamps();
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return this.getTimestampSource().getDocumentTimestamps();
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        return this.getTimestampSource().getAllTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (!timestamp.isProcessed()) {
            throw new DSSException("Timestamp token must be validated first !");
        }
        if (!timestamp.getTimeStampType().isArchivalTimestamp()) {
            throw new DSSException("Only archival timestamp is allowed !");
        }
        this.getTimestampSource().addExternalTimestamp(timestamp);
    }

    public boolean hasTProfile() {
        return Utils.isCollectionNotEmpty(this.getSignatureTimestamps());
    }

    public boolean hasLTProfile() {
        Map<String, List<CertificateToken>> certificateChains = this.getCertificateMapWithinSignatureAndTimestamps(true);
        boolean emptyCRLs = this.getCompleteCRLSource().isEmpty();
        boolean emptyOCSPs = this.getCompleteOCSPSource().isEmpty();
        if (Utils.isMapEmpty(certificateChains) && (emptyCRLs || emptyOCSPs)) {
            return false;
        }
        if (!this.isAllCertChainsHaveRevocationData(certificateChains)) {
            return false;
        }
        return !this.isAllSelfSignedCertificates(certificateChains) || !emptyCRLs || !emptyOCSPs;
    }

    private boolean isAllSelfSignedCertificates(Map<String, List<CertificateToken>> certificateChains) {
        for (Map.Entry<String, List<CertificateToken>> entryCertChain : certificateChains.entrySet()) {
            List<CertificateToken> chain = entryCertChain.getValue();
            if (Utils.collectionSize(chain) == 1) {
                CertificateToken certificateToken = chain.get(0);
                if (certificateToken.isSelfSigned()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isAllCertChainsHaveRevocationData(Map<String, List<CertificateToken>> certificateChains) {
        OCSPAndCRLCertificateVerifier certificateStatusVerifier = new OCSPAndCRLCertificateVerifier(this.getCompleteCRLSource(), this.getCompleteOCSPSource(), this.certPool);
        for (Map.Entry<String, List<CertificateToken>> entryCertChain : certificateChains.entrySet()) {
            LOG.debug("Testing revocation data presence for certificates chain {}", (Object)entryCertChain.getKey());
            if (this.isAllCertsHaveRevocationData(certificateStatusVerifier, entryCertChain.getValue())) continue;
            LOG.debug("Revocation data missing in certificate chain {}", (Object)entryCertChain.getKey());
            return false;
        }
        return true;
    }

    private boolean isAllCertsHaveRevocationData(CertificateStatusVerifier certificateStatusVerifier, List<CertificateToken> certificates) {
        Map<CertificateToken, List<CertificateToken>> orderedCerts = this.order(certificates);
        for (List<CertificateToken> chain : orderedCerts.values()) {
            for (CertificateToken certificateToken : chain) {
                if (!this.isRevocationRequired(certificateToken)) break;
                RevocationToken revocationData = certificateStatusVerifier.check(certificateToken);
                if (revocationData != null) continue;
                return false;
            }
        }
        return true;
    }

    private Map<CertificateToken, List<CertificateToken>> order(List<CertificateToken> certificates) {
        CertificateReorderer reorderer = new CertificateReorderer(certificates);
        return reorderer.getOrderedCertificateChains();
    }

    private boolean isRevocationRequired(CertificateToken certificateToken) {
        if (this.certPool.isTrusted(certificateToken) || certificateToken.isSelfSigned()) {
            return false;
        }
        return !DSSASN1Utils.hasIdPkixOcspNoCheckExtension(certificateToken);
    }

    public boolean hasLTAProfile() {
        return Utils.isCollectionNotEmpty(this.getArchiveTimestamps());
    }

    @Override
    public Set<RevocationToken> getAllRevocationTokens() {
        HashSet<RevocationToken> allRevocations = new HashSet<RevocationToken>();
        allRevocations.addAll(this.getCompleteCRLSource().getAllCRLTokens());
        allRevocations.addAll(this.getCompleteOCSPSource().getAllOCSPTokens());
        return allRevocations;
    }

    @Override
    public List<RevocationToken> getRevocationValuesTokens() {
        ArrayList<RevocationToken> revocationTokens = new ArrayList<RevocationToken>();
        revocationTokens.addAll(this.getCRLSource().getRevocationValuesTokens());
        revocationTokens.addAll(this.getOCSPSource().getRevocationValuesTokens());
        return revocationTokens;
    }

    @Override
    public List<RevocationToken> getAttributeRevocationValuesTokens() {
        ArrayList<RevocationToken> revocationTokens = new ArrayList<RevocationToken>();
        revocationTokens.addAll(this.getCRLSource().getAttributeRevocationValuesTokens());
        revocationTokens.addAll(this.getOCSPSource().getAttributeRevocationValuesTokens());
        return revocationTokens;
    }

    @Override
    public List<RevocationToken> getTimestampValidationDataTokens() {
        ArrayList<RevocationToken> revocationTokens = new ArrayList<RevocationToken>();
        revocationTokens.addAll(this.getCRLSource().getTimestampValidationDataTokens());
        revocationTokens.addAll(this.getOCSPSource().getTimestampValidationDataTokens());
        return revocationTokens;
    }

    @Override
    public List<RevocationToken> getDSSDictionaryRevocationTokens() {
        ArrayList<RevocationToken> revocationTokens = new ArrayList<RevocationToken>();
        revocationTokens.addAll(this.getCRLSource().getDSSDictionaryTokens());
        revocationTokens.addAll(this.getOCSPSource().getDSSDictionaryTokens());
        return revocationTokens;
    }

    @Override
    public List<RevocationToken> getVRIDictionaryRevocationTokens() {
        ArrayList<RevocationToken> revocationTokens = new ArrayList<RevocationToken>();
        revocationTokens.addAll(this.getCRLSource().getVRIDictionaryTokens());
        revocationTokens.addAll(this.getOCSPSource().getVRIDictionaryTokens());
        return revocationTokens;
    }

    @Override
    public List<CRLRef> getCompleteRevocationCRLReferences() {
        return this.getCRLSource().getCompleteRevocationRefs();
    }

    @Override
    public List<CRLRef> getAttributeRevocationCRLReferences() {
        return this.getCRLSource().getAttributeRevocationRefs();
    }

    @Override
    public List<CRLRef> getTimestampRevocationCRLReferences() {
        return this.getCRLSource().getTimestampRevocationRefs();
    }

    @Override
    public List<OCSPRef> getCompleteRevocationOCSPReferences() {
        return this.getOCSPSource().getCompleteRevocationRefs();
    }

    @Override
    public List<OCSPRef> getAttributeRevocationOCSPReferences() {
        return this.getOCSPSource().getAttributeRevocationRefs();
    }

    @Override
    public List<OCSPRef> getTimestampRevocationOCSPReferences() {
        return this.getOCSPSource().getTimestampRevocationRefs();
    }

    @Override
    public List<RevocationRef> getAllFoundRevocationRefs() {
        ArrayList<RevocationRef> revocationRefs = new ArrayList<RevocationRef>();
        revocationRefs.addAll(this.getCompleteCRLSource().getAllCRLReferences());
        revocationRefs.addAll(this.getCompleteOCSPSource().getAllOCSPReferences());
        return revocationRefs;
    }

    @Override
    public List<RevocationRef> getOrphanRevocationRefs() {
        ArrayList<RevocationRef> orphanRevocationRefs = new ArrayList<RevocationRef>();
        orphanRevocationRefs.addAll(this.getCompleteCRLSource().getOrphanCrlRefs());
        orphanRevocationRefs.addAll(this.getCompleteOCSPSource().getOrphanOCSPRefs());
        return orphanRevocationRefs;
    }

    @Override
    public List<RevocationToken> getCompleteRevocationTokens() {
        ArrayList<RevocationToken> revocations = new ArrayList<RevocationToken>();
        revocations.addAll(this.getCRLSource().findTokensFromRefs(this.getCRLSource().getCompleteRevocationRefs()));
        revocations.addAll(this.getOCSPSource().findTokensFromRefs(this.getOCSPSource().getCompleteRevocationRefs()));
        return revocations;
    }

    @Override
    public List<RevocationToken> getAttributeRevocationTokens() {
        ArrayList<RevocationToken> revocations = new ArrayList<RevocationToken>();
        revocations.addAll(this.getCRLSource().findTokensFromRefs(this.getCRLSource().getAttributeRevocationRefs()));
        revocations.addAll(this.getOCSPSource().findTokensFromRefs(this.getOCSPSource().getAttributeRevocationRefs()));
        return revocations;
    }

    @Override
    public List<RevocationRef> findRefsForRevocationToken(RevocationToken revocationToken) {
        ArrayList<RevocationRef> revocationRefs = new ArrayList<RevocationRef>();
        if (RevocationType.CRL.equals((Object)revocationToken.getRevocationType())) {
            revocationRefs.addAll(this.getCompleteCRLSource().findRefsForRevocationToken((CRLToken)revocationToken));
        } else {
            revocationRefs.addAll(this.getCompleteOCSPSource().findRefsForRevocationToken((OCSPToken)revocationToken));
        }
        return revocationRefs;
    }

    @Override
    public List<RevocationRef> findRefsForRevocationIdentifier(EncapsulatedRevocationTokenIdentifier revocationIdentifier) {
        ArrayList<RevocationRef> revocationRefs = new ArrayList<RevocationRef>();
        if (revocationIdentifier instanceof CRLBinary) {
            revocationRefs.addAll(this.getCompleteCRLSource().getReferencesForCRLIdentifier((CRLBinary)revocationIdentifier));
        } else {
            revocationRefs.addAll(this.getCompleteOCSPSource().getReferencesForOCSPIdentifier((OCSPResponseBinary)revocationIdentifier));
        }
        return revocationRefs;
    }

    @Override
    public List<EncapsulatedRevocationTokenIdentifier> getAllFoundRevocationIdentifiers() {
        ArrayList<EncapsulatedRevocationTokenIdentifier> allFoundRevocationTokens = new ArrayList<EncapsulatedRevocationTokenIdentifier>();
        allFoundRevocationTokens.addAll(this.getCompleteCRLSource().getCRLBinaryList());
        allFoundRevocationTokens.addAll(this.getCompleteOCSPSource().getOCSPResponsesList());
        return allFoundRevocationTokens;
    }

    @Override
    public boolean isDocHashOnlyValidation() {
        if (Utils.isCollectionNotEmpty(this.detachedContents)) {
            for (DSSDocument dssDocument : this.detachedContents) {
                if (dssDocument instanceof DigestDocument) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isHashOnlyValidation() {
        return false;
    }

    @Override
    public byte[] getMessageDigestValue() {
        return null;
    }

    @Override
    public String getSignatureFieldName() {
        return null;
    }

    @Override
    public String getSignerName() {
        return null;
    }

    @Override
    public String getFilter() {
        return null;
    }

    @Override
    public String getSubFilter() {
        return null;
    }

    @Override
    public String getContactInfo() {
        return null;
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public int[] getSignatureByteRange() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultAdvancedSignature)) {
            return false;
        }
        DefaultAdvancedSignature das = (DefaultAdvancedSignature)obj;
        return this.getDSSId().equals(das.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }

    public static class RevocationDataForInclusion {
        public final List<CRLToken> crlTokens;
        public final List<OCSPToken> ocspTokens;

        public RevocationDataForInclusion(List<CRLToken> crlTokens, List<OCSPToken> ocspTokens) {
            this.crlTokens = crlTokens;
            this.ocspTokens = ocspTokens;
        }

        public boolean isEmpty() {
            return this.crlTokens.isEmpty() && this.ocspTokens.isEmpty();
        }
    }
}

