/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.ProcessExecutorProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.executor.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.DefaultCertificateProcessExecutor;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Date;
import java.util.Objects;

public class CertificateValidator
implements ProcessExecutorProvider<CertificateProcessExecutor> {
    private Date validationTime = new Date();
    private final CertificateToken token;
    private CertificateVerifier certificateVerifier;
    private CertificateProcessExecutor processExecutor;

    private CertificateValidator(CertificateToken token) {
        Objects.requireNonNull(token, "The certificate is missing");
        this.token = token;
    }

    public static CertificateValidator fromCertificate(CertificateToken token) {
        return new CertificateValidator(token);
    }

    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
    }

    public CertificateReports validate() {
        ValidationPolicy defaultPolicy = null;
        try {
            defaultPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the default policy", e);
        }
        return this.validate(defaultPolicy);
    }

    public CertificateReports validate(ValidationPolicy validationPolicy) {
        SignatureValidationContext svc = new SignatureValidationContext();
        svc.initialize(this.certificateVerifier);
        svc.addCertificateTokenForVerification(this.token);
        svc.setCurrentTime(this.validationTime);
        svc.validate();
        XmlDiagnosticData diagnosticData = new DiagnosticDataBuilder().usedCertificates(svc.getProcessedCertificates()).usedRevocations(svc.getProcessedRevocations()).includeRawCertificateTokens(this.certificateVerifier.isIncludeCertificateTokenValues()).includeRawRevocationData(this.certificateVerifier.isIncludeCertificateRevocationValues()).certificateSourceTypes(svc.getCertificateSourceTypes()).trustedCertificateSource(this.certificateVerifier.getTrustedCertSource()).validationDate(svc.getCurrentTime()).build();
        CertificateProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setDiagnosticData(diagnosticData);
        executor.setCertificateId(this.token.getDSSIdAsString());
        executor.setCurrentTime(svc.getCurrentTime());
        return (CertificateReports)executor.execute();
    }

    @Override
    public void setProcessExecutor(CertificateProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public CertificateProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = new DefaultCertificateProcessExecutor();
        }
        return this.processExecutor;
    }
}

