/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.validation.IssuerSerialInfo;
import java.io.Serializable;

public class CertificateRef
implements Serializable {
    private static final long serialVersionUID = -325165164194282066L;
    private Digest certDigest;
    private IssuerSerialInfo issuerInfo;
    private CertificateRefOrigin origin;
    private String dssId;

    public Digest getCertDigest() {
        return this.certDigest;
    }

    public void setCertDigest(Digest certDigest) {
        this.certDigest = certDigest;
    }

    public IssuerSerialInfo getIssuerInfo() {
        return this.issuerInfo;
    }

    public void setIssuerInfo(IssuerSerialInfo issuerInfo) {
        this.issuerInfo = issuerInfo;
    }

    public CertificateRefOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(CertificateRefOrigin origin) {
        this.origin = origin;
    }

    public String getDSSIdAsString() {
        if (this.dssId == null) {
            this.dssId = "C-" + this.certDigest.getHexValue().toUpperCase();
        }
        return this.dssId;
    }

    public String toString() {
        return "CertificateRef [certDigest=" + this.certDigest + ", issuerInfo=" + this.issuerInfo + ", origin=" + (Object)((Object)this.origin) + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CertificateRef)) {
            return false;
        }
        CertificateRef o = (CertificateRef)obj;
        if (this.certDigest == null && o.getCertDigest() != null || this.certDigest != null && !this.certDigest.equals(o.getCertDigest())) {
            return false;
        }
        if (this.issuerInfo == null && o.getIssuerInfo() != null || this.issuerInfo != null && !this.issuerInfo.equals(o.getIssuerInfo())) {
            return false;
        }
        return (this.origin != null || o.getOrigin() == null) && (this.origin == null || this.origin.equals((Object)o.getOrigin()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certDigest == null ? 0 : this.certDigest.hashCode());
        result = 31 * result + (this.issuerInfo == null ? 0 : this.issuerInfo.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        return result;
    }
}

