/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSCRLSource
extends SignatureCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSCRLSource.class);
    protected final transient CMSSignedData cmsSignedData;
    protected final transient AttributeTable unsignedAttributes;
    private List<CRLBinary> signedDataCRLIdentifiers = new ArrayList<CRLBinary>();

    public CMSCRLSource(CMSSignedData cmsSignedData, AttributeTable unsignedAttributes) {
        this.cmsSignedData = cmsSignedData;
        this.unsignedAttributes = unsignedAttributes;
        this.extract();
    }

    protected RevocationOrigin getRevocationValuesOrigin() {
        return RevocationOrigin.REVOCATION_VALUES;
    }

    protected RevocationRefOrigin getCompleteRevocationRefsOrigin() {
        return RevocationRefOrigin.COMPLETE_REVOCATION_REFS;
    }

    protected RevocationRefOrigin getAttributeRevocationRefsOrigin() {
        return RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS;
    }

    public List<CRLBinary> getSignedDataCRLIdentifiers() {
        return this.signedDataCRLIdentifiers;
    }

    private void extract() {
        this.collectFromSignedData();
        if (this.unsignedAttributes != null) {
            this.collectRevocationValues(PKCSObjectIdentifiers.id_aa_ets_revocationValues, this.getRevocationValuesOrigin());
            this.collectRevocationRefs(PKCSObjectIdentifiers.id_aa_ets_revocationRefs, this.getCompleteRevocationRefsOrigin());
            this.collectRevocationRefs(OID.attributeRevocationRefsOid, this.getAttributeRevocationRefsOrigin());
        }
    }

    private void collectFromSignedData() {
        Store<X509CRLHolder> crLs = this.cmsSignedData.getCRLs();
        Collection<X509CRLHolder> collection = crLs.getMatches(null);
        for (X509CRLHolder x509CRLHolder : collection) {
            this.signedDataCRLIdentifiers.add(this.addX509CRLHolder(x509CRLHolder, this.getRevocationValuesOrigin()));
        }
    }

    private void collectRevocationValues(ASN1ObjectIdentifier revocationValuesAttribute, RevocationOrigin origin) {
        ASN1Encodable attValue = DSSASN1Utils.getAsn1Encodable(this.unsignedAttributes, revocationValuesAttribute);
        RevocationValues revValues = DSSASN1Utils.getRevocationValues(attValue);
        if (revValues != null) {
            for (CertificateList revValue : revValues.getCrlVals()) {
                this.addX509CRLHolder(new X509CRLHolder(revValue), origin);
            }
        }
    }

    protected CRLBinary addX509CRLHolder(X509CRLHolder crlHolder, RevocationOrigin origin) {
        try {
            return this.addCRLBinary(crlHolder.getEncoded(), origin);
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    private void collectRevocationRefs(ASN1ObjectIdentifier revocationRefsAttribute, RevocationRefOrigin origin) {
        try {
            ASN1Encodable attrValue = DSSASN1Utils.getAsn1Encodable(this.unsignedAttributes, revocationRefsAttribute);
            if (attrValue != null) {
                ASN1Sequence revocationRefs = (ASN1Sequence)attrValue;
                for (int ii = 0; ii < revocationRefs.size(); ++ii) {
                    CrlOcspRef crlOcspRef = CrlOcspRef.getInstance(revocationRefs.getObjectAt(ii));
                    CrlListID crlIds = crlOcspRef.getCrlids();
                    if (crlIds == null) continue;
                    for (CrlValidatedID id : crlIds.getCrls()) {
                        CRLRef crlRef = new CRLRef(id, origin);
                        this.addReference(crlRef, origin);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during extraction of revocation references from  signature unsigned properties. Revocations for origin {} were not stored", (Object)origin.toString(), (Object)e);
        }
    }
}

