/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.ListCRLSource;
import eu.europa.esig.dss.validation.ListOCSPSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface AdvancedSignature
extends Serializable {
    public String getSignatureFilename();

    public void setSignatureFilename(String var1);

    public List<DSSDocument> getDetachedContents();

    public void setDetachedContents(List<DSSDocument> var1);

    public List<DSSDocument> getContainerContents();

    public void setContainerContents(List<DSSDocument> var1);

    public void setManifestFiles(List<ManifestFile> var1);

    public List<DSSDocument> getManifestedDocuments();

    public CertificateToken getProvidedSigningCertificateToken();

    public void setProvidedSigningCertificateToken(CertificateToken var1);

    public SignatureForm getSignatureForm();

    public SignatureAlgorithm getSignatureAlgorithm();

    public EncryptionAlgorithm getEncryptionAlgorithm();

    public DigestAlgorithm getDigestAlgorithm();

    public MaskGenerationFunction getMaskGenerationFunction();

    public Date getSigningTime();

    public SignatureCertificateSource getCertificateSource();

    public SignatureCRLSource getCRLSource();

    public SignatureOCSPSource getOCSPSource();

    public ListCRLSource getCompleteCRLSource();

    public ListOCSPSource getCompleteOCSPSource();

    public SignatureTimestampSource getTimestampSource();

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate();

    public void setMasterSignature(AdvancedSignature var1);

    public AdvancedSignature getMasterSignature();

    public CertificateToken getSigningCertificateToken();

    public void checkSignatureIntegrity();

    public SignatureCryptographicVerification getSignatureCryptographicVerification();

    public void checkSigningCertificate();

    public SignaturePolicy getPolicyId();

    public SignatureProductionPlace getSignatureProductionPlace();

    public CommitmentType getCommitmentTypeIndication();

    public String getContentType();

    public String getMimeType();

    public String getContentIdentifier();

    public String getContentHints();

    public List<SignerRole> getSignerRoles();

    public List<SignerRole> getClaimedSignerRoles();

    public List<SignerRole> getCertifiedSignerRoles();

    public List<CertificateToken> getCertificates();

    public List<CertificateToken> getCertificateListWithinSignatureAndTimestamps();

    public List<TimestampToken> getContentTimestamps();

    public List<TimestampToken> getSignatureTimestamps();

    public List<TimestampToken> getTimestampsX1();

    public List<TimestampToken> getTimestampsX2();

    public List<TimestampToken> getArchiveTimestamps();

    public List<TimestampToken> getDocumentTimestamps();

    public List<TimestampToken> getAllTimestamps();

    public void addExternalTimestamp(TimestampToken var1);

    public List<AdvancedSignature> getCounterSignatures();

    public List<CertificateRef> getCertificateRefs();

    public List<CertificateRef> getOrphanCertificateRefs();

    public SignatureIdentifier getDSSId();

    public String getId();

    public String getDAIdentifier();

    public boolean isDataForSignatureLevelPresent(SignatureLevel var1);

    public SignatureLevel getDataFoundUpToLevel();

    public SignatureLevel[] getSignatureLevels();

    public void prepareTimestamps(ValidationContext var1);

    public void validateStructure();

    public void populateCRLTokenLists(SignatureCRLSource var1);

    public void populateOCSPTokenLists(SignatureOCSPSource var1);

    public String getStructureValidationResult();

    public void checkSignaturePolicy(SignaturePolicyProvider var1);

    public void findSignatureScope(SignatureScopeFinder var1);

    public List<SignatureScope> getSignatureScopes();

    public boolean isDocHashOnlyValidation();

    public boolean isHashOnlyValidation();

    public byte[] getSignatureValue();

    public List<ReferenceValidation> getReferenceValidations();

    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm var1);

    public Set<RevocationToken> getAllRevocationTokens();

    public List<RevocationToken> getRevocationValuesTokens();

    public List<RevocationToken> getAttributeRevocationValuesTokens();

    public List<RevocationToken> getTimestampValidationDataTokens();

    public List<RevocationToken> getDSSDictionaryRevocationTokens();

    public List<RevocationToken> getVRIDictionaryRevocationTokens();

    public List<RevocationToken> getCompleteRevocationTokens();

    public List<RevocationToken> getAttributeRevocationTokens();

    public List<CRLRef> getCompleteRevocationCRLReferences();

    public List<CRLRef> getAttributeRevocationCRLReferences();

    public List<CRLRef> getTimestampRevocationCRLReferences();

    public List<OCSPRef> getCompleteRevocationOCSPReferences();

    public List<OCSPRef> getAttributeRevocationOCSPReferences();

    public List<OCSPRef> getTimestampRevocationOCSPReferences();

    public List<EncapsulatedRevocationTokenIdentifier> getAllFoundRevocationIdentifiers();

    public List<RevocationRef> getAllFoundRevocationRefs();

    public List<RevocationRef> getOrphanRevocationRefs();

    public List<RevocationRef> findRefsForRevocationToken(RevocationToken var1);

    public List<RevocationRef> findRefsForRevocationIdentifier(EncapsulatedRevocationTokenIdentifier var1);

    public byte[] getMessageDigestValue();

    public String getSignatureFieldName();

    public String getSignerName();

    public String getFilter();

    public String getSubFilter();

    public String getContactInfo();

    public String getReason();

    public int[] getSignatureByteRange();
}

