/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.utils.guava.impl;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import eu.europa.esig.dss.utils.IUtils;
import eu.europa.esig.dss.utils.guava.impl.FilterByExtensions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class GoogleGuavaUtils
implements IUtils {
    private static final String STRING_EMPTY = "";

    @Override
    public boolean isStringEmpty(String text) {
        return Strings.isNullOrEmpty(text);
    }

    @Override
    public boolean isStringNotEmpty(String text) {
        return !Strings.isNullOrEmpty(text);
    }

    @Override
    public boolean isStringBlank(String text) {
        return Strings.isNullOrEmpty(text) || CharMatcher.whitespace().matchesAllOf(text);
    }

    @Override
    public boolean isStringNotBlank(String text) {
        return !this.isStringBlank(text);
    }

    @Override
    public boolean areStringsEqual(String text1, String text2) {
        if (text1 == null && text2 == null) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        return text1.equals(text2);
    }

    @Override
    public boolean areStringsEqualIgnoreCase(String text1, String text2) {
        if (text1 == null && text2 == null) {
            return true;
        }
        if (text1 == null || text2 == null) {
            return false;
        }
        return text1.equalsIgnoreCase(text2);
    }

    @Override
    public boolean isStringDigits(String text) {
        return !Strings.isNullOrEmpty(text) && CharMatcher.inRange('0', '9').matchesAllOf(text);
    }

    @Override
    public String trim(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return text;
        }
        return text.trim();
    }

    @Override
    public String joinStrings(Collection<String> strings, String separator) {
        if (strings == null) {
            return null;
        }
        if (Strings.isNullOrEmpty(separator)) {
            separator = STRING_EMPTY;
        }
        Joiner joiner = Joiner.on(separator);
        return joiner.join(strings);
    }

    @Override
    public String substringAfter(String text, String after) {
        if (Strings.isNullOrEmpty(text)) {
            return text;
        }
        if (after == null) {
            return STRING_EMPTY;
        }
        int indexOf = text.indexOf(after);
        if (indexOf == -1) {
            return STRING_EMPTY;
        }
        return text.substring(indexOf + after.length());
    }

    @Override
    public boolean endsWithIgnoreCase(String text, String expected) {
        if (Strings.isNullOrEmpty(text) || Strings.isNullOrEmpty(expected)) {
            return false;
        }
        return this.lowerCase(text).endsWith(this.lowerCase(expected));
    }

    @Override
    public String lowerCase(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return text;
        }
        return text.toLowerCase();
    }

    @Override
    public String upperCase(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return text;
        }
        return text.toUpperCase();
    }

    @Override
    public boolean isArrayEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    @Override
    public boolean isArrayNotEmpty(Object[] array) {
        return !this.isArrayEmpty(array);
    }

    @Override
    public boolean isArrayEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    @Override
    public boolean isArrayNotEmpty(byte[] array) {
        return !this.isArrayEmpty(array);
    }

    @Override
    public byte[] subarray(byte[] array, int start, int length) {
        if (array == null) {
            return null;
        }
        return Arrays.copyOfRange(array, start, length);
    }

    @Override
    public boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }

    @Override
    public boolean isCollectionEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    @Override
    public boolean isCollectionNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    @Override
    public boolean isMapEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @Override
    public boolean isMapNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    @Override
    public int collectionSize(Collection collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    @Override
    public String toHex(byte[] bytes) {
        return BaseEncoding.base16().encode(bytes).toLowerCase();
    }

    @Override
    public byte[] fromHex(String hex) {
        return BaseEncoding.base16().lowerCase().decode(Ascii.toLowerCase(hex));
    }

    @Override
    public boolean isBase64Encoded(String base64String) {
        return BaseEncoding.base64().canDecode(CharMatcher.whitespace().removeFrom(base64String));
    }

    @Override
    public String toBase64(byte[] bytes) {
        return BaseEncoding.base64().encode(bytes);
    }

    @Override
    public byte[] fromBase64(String base64) {
        return BaseEncoding.base64().decode(CharMatcher.whitespace().removeFrom(base64));
    }

    @Override
    public byte[] toByteArray(InputStream is) throws IOException {
        return ByteStreams.toByteArray(is);
    }

    @Override
    public void closeQuietly(Closeable closeable) {
        try {
            Closeables.close(closeable, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void copy(InputStream is, OutputStream os) throws IOException {
        ByteStreams.copy(is, os);
    }

    @Override
    public void write(byte[] content, OutputStream os) throws IOException {
        ByteStreams.copy(new ByteArrayInputStream(content), os);
    }

    @Override
    public long getInputStreamSize(InputStream is) throws IOException {
        return ByteStreams.exhaust(is);
    }

    @Override
    public void cleanDirectory(File directory) throws IOException {
        File[] listFiles;
        Objects.requireNonNull(directory, "Directory cannot be null");
        if (!directory.exists() || !directory.isDirectory()) {
            throw new FileNotFoundException("Directory '" + directory.getAbsolutePath() + "' not found");
        }
        if (directory.isDirectory() && (listFiles = directory.listFiles()) != null) {
            for (File file : listFiles) {
                if (file.isDirectory()) {
                    this.cleanDirectory(file);
                    continue;
                }
                if (!file.isFile()) continue;
                file.delete();
            }
        }
    }

    @Override
    public Collection<File> listFiles(File folder, String[] extensions, boolean recursive) {
        return Lists.newArrayList(Iterables.filter(Files.fileTraverser().depthFirstPostOrder(folder), new FilterByExtensions(extensions)));
    }
}

