/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.model.DSSException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;

public final class SunPKCS11Initializer {
    private static final String SUN_PKCS11_PROVIDERNAME = "SunPKCS11";

    private SunPKCS11Initializer() {
    }

    public static Provider getProvider(String configString) {
        try {
            Provider provider = Security.getProvider(SUN_PKCS11_PROVIDERNAME);
            Method configureMethod = provider.getClass().getMethod("configure", String.class);
            return (Provider)configureMethod.invoke((Object)provider, "--" + configString);
        }
        catch (Exception e) {
            throw new DSSException("Unable to instantiate PKCS11 (JDK >= 9)", e);
        }
    }
}

