/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone;

import eu.europa.esig.dss.standalone.RemoteDocumentSignatureServiceBuilder;
import eu.europa.esig.dss.standalone.controller.SignatureController;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(DSSApplication.class);
    private RemoteDocumentSignatureService signatureService;
    private Stage stage;

    public void start(Stage stage) {
        this.stage = stage;
        this.stage.setTitle("Digital Signature Service Application");
        this.stage.setResizable(true);
        this.stage.getIcons().add((Object)new Image("/dss-logo.png"));
        this.signatureService = RemoteDocumentSignatureServiceBuilder.build();
        this.initLayout();
    }

    private void initLayout() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(DSSApplication.class.getResource("/fxml/screen.fxml"));
            Pane pane = (Pane)loader.load();
            Scene scene = new Scene((Parent)pane);
            scene.getStylesheets().add((Object)"/styles/style.css");
            this.stage.setScene(scene);
            this.stage.show();
            SignatureController controller = (SignatureController)loader.getController();
            controller.setStage(this.stage);
            controller.setSignatureService(this.signatureService);
        }
        catch (Exception e) {
            LOG.error("Unable to init layout : " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        DSSApplication.launch(DSSApplication.class, (String[])args);
    }

    public Stage getStage() {
        return this.stage;
    }
}

