/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPTokenBuilder;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPTokenUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineOCSPSource
implements OCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineOCSPSource.class);
    private final Map<OCSPResponseBinary, Set<RevocationOrigin>> ocspResponseOriginsMap = new HashMap<OCSPResponseBinary, Set<RevocationOrigin>>();

    @Override
    public final OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        OCSPResponseBinary bestOCSPResponse;
        if (this.isEmpty()) {
            return null;
        }
        if (LOG.isTraceEnabled()) {
            String dssIdAsString = certificateToken.getDSSIdAsString();
            LOG.trace("--> OfflineOCSPSource queried for {} contains: {} element(s).", (Object)dssIdAsString, (Object)this.ocspResponseOriginsMap.size());
        }
        if ((bestOCSPResponse = this.findBestOcspResponse(certificateToken, issuerCertificateToken)) != null) {
            OCSPTokenBuilder ocspTokenBuilder = new OCSPTokenBuilder(bestOCSPResponse.getBasicOCSPResp(), certificateToken, issuerCertificateToken);
            try {
                OCSPToken ocspToken = ocspTokenBuilder.build();
                OCSPTokenUtils.checkTokenValidity(ocspToken, certificateToken, issuerCertificateToken);
                this.storeOCSPToken(bestOCSPResponse, ocspToken);
                ocspToken.setOrigins(this.getRevocationOrigins(bestOCSPResponse));
                return ocspToken;
            }
            catch (OCSPException e) {
                LOG.error("An error occurred during an attempt to build OCSP Token. Return null", e);
                return null;
            }
        }
        return null;
    }

    private OCSPResponseBinary findBestOcspResponse(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        OCSPResponseBinary bestOCSPResponse = null;
        Date bestUpdate = null;
        CertificateID certId = DSSRevocationUtils.getOCSPCertificateID(certificateToken, issuerCertificateToken);
        for (OCSPResponseBinary response : this.ocspResponseOriginsMap.keySet()) {
            for (SingleResp singleResp : response.getBasicOCSPResp().getResponses()) {
                if (!DSSRevocationUtils.matches(certId, singleResp)) continue;
                Date thisUpdate = singleResp.getThisUpdate();
                if (bestUpdate != null && !thisUpdate.after(bestUpdate)) continue;
                bestOCSPResponse = response;
                bestUpdate = thisUpdate;
            }
        }
        return bestOCSPResponse;
    }

    public abstract void appendContainedOCSPResponses();

    public Collection<OCSPResponseBinary> getOCSPResponsesList() {
        Collection<Object> ocspResponsesList = new ArrayList();
        if (!this.isEmpty()) {
            ocspResponsesList = this.ocspResponseOriginsMap.keySet();
        }
        return Collections.unmodifiableCollection(ocspResponsesList);
    }

    public boolean isEmpty() {
        if (Utils.isMapEmpty(this.ocspResponseOriginsMap)) {
            this.appendContainedOCSPResponses();
        }
        return Utils.isMapEmpty(this.ocspResponseOriginsMap);
    }

    protected void storeOCSPToken(OCSPResponseBinary ocspResponse, OCSPToken ocspToken) {
    }

    public OCSPResponseBinary getIdentifier(OCSPRef ocspRef) {
        if (ocspRef.getDigest() != null) {
            return this.getIdentifier(ocspRef.getDigest());
        }
        for (OCSPResponseBinary ocspResponse : this.ocspResponseOriginsMap.keySet()) {
            if (!ocspRef.getProducedAt().equals(ocspResponse.getBasicOCSPResp().getProducedAt())) continue;
            ResponderID responderID = ocspResponse.getBasicOCSPResp().getResponderId().toASN1Primitive();
            if ((ocspRef.getResponderId().getKey() == null || !Arrays.equals(ocspRef.getResponderId().getKey(), responderID.getKeyHash())) && (ocspRef.getResponderId().getName() == null || responderID.getName() == null || !ocspRef.getResponderId().getName().equals(responderID.getName().toString()))) continue;
            return ocspResponse;
        }
        return null;
    }

    public OCSPResponseBinary getIdentifier(Digest digest) {
        if (digest == null) {
            return null;
        }
        for (OCSPResponseBinary ocspResponse : this.ocspResponseOriginsMap.keySet()) {
            byte[] digestValue = ocspResponse.getDigestValue(digest.getAlgorithm());
            if (!Arrays.equals(digest.getValue(), digestValue)) continue;
            return ocspResponse;
        }
        return null;
    }

    protected void addOCSPResponse(OCSPResponseBinary ocspResponse, RevocationOrigin origin) {
        Set<RevocationOrigin> origins = this.ocspResponseOriginsMap.get(ocspResponse);
        if (origins == null) {
            origins = new HashSet<RevocationOrigin>();
            this.ocspResponseOriginsMap.put(ocspResponse, origins);
        }
        origins.add(origin);
    }

    public Set<RevocationOrigin> getRevocationOrigins(OCSPResponseBinary ocspResponse) {
        return this.ocspResponseOriginsMap.get(ocspResponse);
    }
}

