/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.ResponderId;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPRef
extends RevocationRef {
    private static final long serialVersionUID = -4757221403735075782L;
    private static final Logger LOG = LoggerFactory.getLogger(OCSPRef.class);
    private Date producedAt = null;
    private ResponderId responderId = null;

    public OCSPRef(Digest digest, Date producedAt, ResponderId responderId, RevocationRefOrigin origin) {
        this.digest = digest;
        this.producedAt = producedAt;
        this.responderId = responderId;
        this.origins = new HashSet<RevocationRefOrigin>(Arrays.asList(origin));
    }

    public OCSPRef(OcspResponsesID ocspResponsesID, RevocationRefOrigin origin) {
        byte[] key;
        OtherHash otherHash = ocspResponsesID.getOcspRepHash();
        if (otherHash != null) {
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(otherHash.getHashAlgorithm().getAlgorithm().getId());
            byte[] digestValue = otherHash.getHashValue();
            this.digest = new Digest(digestAlgorithm, digestValue);
        } else {
            LOG.warn("Digest is not present for an OCSPRef with location [{}]!", (Object)origin.name());
        }
        this.producedAt = DSSASN1Utils.getDate(ocspResponsesID.getOcspIdentifier().getProducedAt());
        this.responderId = new ResponderId();
        X500Name name = ocspResponsesID.getOcspIdentifier().getOcspResponderID().getName();
        if (name != null) {
            this.responderId.setName(name.toString());
        }
        if (Utils.isArrayNotEmpty(key = ocspResponsesID.getOcspIdentifier().getOcspResponderID().getKeyHash())) {
            this.responderId.setKey(key);
        }
        this.origins = new HashSet<RevocationRefOrigin>(Arrays.asList(origin));
    }

    public Date getProducedAt() {
        return this.producedAt;
    }

    public ResponderId getResponderId() {
        return this.responderId;
    }

    @Override
    public String getDSSIdAsString() {
        byte[] bytes;
        if (this.digest != null) {
            return super.getDSSIdAsString();
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(baos);){
            if (this.producedAt != null) {
                dos.writeLong(this.producedAt.getTime());
            }
            if (this.responderId.getKey() != null) {
                dos.write(this.responderId.getKey());
            }
            if (this.responderId.getName() != null) {
                dos.writeChars(this.responderId.getName());
            }
            dos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Cannot build DSS ID for the OCSP Ref.", e);
        }
        return "R-" + DSSUtils.toHex(DSSUtils.digest(DigestAlgorithm.SHA256, bytes)).toUpperCase();
    }

    @Override
    public String toString() {
        if (this.responderId.getName() != null) {
            return "OCSP Reference produced at [" + DSSUtils.formatInternal(this.producedAt) + "] with Responder Name: [" + this.responderId.getName() + "]";
        }
        return "OCSP Reference produced at [" + DSSUtils.formatInternal(this.producedAt) + "] with Responder key 64base: [" + Utils.toBase64(this.responderId.getKey()) + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OCSPRef)) {
            return false;
        }
        OCSPRef o = (OCSPRef)obj;
        return !(!this.producedAt.equals(o.producedAt) || this.responderId.getName() != null && !this.responderId.getName().equals(o.getResponderId().getName()) || this.responderId.getKey() != null && !Arrays.equals(this.responderId.getKey(), o.getResponderId().getKey())) && (this.digest == null || this.digest.equals(o.getDigest()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
        result = 31 * result + (this.producedAt == null ? 0 : this.producedAt.hashCode());
        result = 31 * result + (this.responderId.getName() == null ? 0 : this.responderId.getName().hashCode());
        result = 31 * result + (this.responderId.getKey() == null ? 0 : Arrays.hashCode(this.responderId.getKey()));
        return result;
    }
}

