/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourcesCRLSource
extends OfflineCRLSource {
    private static final long serialVersionUID = -985602836642741439L;
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourcesCRLSource.class);

    public ExternalResourcesCRLSource(String ... paths) {
        for (String pathItem : paths) {
            try {
                this.addCRLToken(this.getClass().getResourceAsStream(pathItem));
            }
            catch (Exception e) {
                LOG.error("Unable to load '" + pathItem + "'", e);
            }
        }
    }

    public ExternalResourcesCRLSource(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            this.addCRLToken(inputStream);
        }
    }

    private void addCRLToken(InputStream inputStream) {
        try (InputStream is = inputStream;){
            this.addCRLBinary(Utils.toByteArray(is), RevocationOrigin.EXTERNAL);
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }
}

