/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.bouncycastle.asn1.esf.CrlIdentifier;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.x500.X500Name;

public final class CRLRef
extends RevocationRef {
    private static final long serialVersionUID = -6785644604097791548L;
    private X500Name crlIssuer;
    private Date crlIssuedTime;
    private BigInteger crlNumber;

    public CRLRef(Digest digest, RevocationRefOrigin origin) {
        this.digest = digest;
        this.origins = new HashSet<RevocationRefOrigin>(Arrays.asList(origin));
    }

    public CRLRef(CrlValidatedID cmsRef, RevocationRefOrigin origin) {
        try {
            CrlIdentifier crlIdentifier = cmsRef.getCrlIdentifier();
            if (crlIdentifier != null) {
                this.crlIssuer = crlIdentifier.getCrlIssuer();
                this.crlIssuedTime = crlIdentifier.getCrlIssuedTime().getDate();
                this.crlNumber = crlIdentifier.getCrlNumber();
            }
            OtherHash crlHash = cmsRef.getCrlHash();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(crlHash.getHashAlgorithm().getAlgorithm().getId());
            byte[] digestValue = crlHash.getHashValue();
            this.digest = new Digest(digestAlgorithm, digestValue);
            this.origins = new HashSet<RevocationRefOrigin>(Arrays.asList(origin));
        }
        catch (ParseException ex) {
            throw new DSSException(ex);
        }
    }

    public X500Name getCrlIssuer() {
        return this.crlIssuer;
    }

    public Date getCrlIssuedTime() {
        return this.crlIssuedTime;
    }

    public BigInteger getCrlNumber() {
        return this.crlNumber;
    }

    @Override
    public String toString() {
        return "CRL Reference with Digest [" + super.toString() + "]";
    }
}

