/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.utils.Utils;
import java.util.Date;
import java.util.Set;

public abstract class RevocationToken
extends Token {
    protected CertificateToken relatedCertificate;
    protected RevocationType revocationType;
    private Set<RevocationOrigin> origins;
    protected String sourceURL;
    protected boolean available;
    protected Boolean status;
    protected Date productionDate;
    protected Date thisUpdate;
    protected Date nextUpdate;
    protected Date revocationDate;
    protected Date expiredCertsOnCRL;
    protected Date archiveCutOff;
    protected boolean certHashPresent = false;
    protected boolean certHashMatch = false;
    protected RevocationReason reason;
    protected String revocationTokenKey;

    public RevocationType getRevocationType() {
        return this.revocationType;
    }

    public String getRelatedCertificateID() {
        if (this.relatedCertificate != null) {
            return this.relatedCertificate.getDSSIdAsString();
        }
        return null;
    }

    public void setRelatedCertificate(CertificateToken relatedCertificate) {
        this.relatedCertificate = relatedCertificate;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public Set<RevocationOrigin> getOrigins() {
        return this.origins;
    }

    public RevocationOrigin getFirstOrigin() {
        Set<RevocationOrigin> origins = this.getOrigins();
        if (Utils.isCollectionNotEmpty(origins)) {
            return origins.iterator().next();
        }
        return null;
    }

    public void setOrigins(Set<RevocationOrigin> origins) {
        this.origins = origins;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Date getProductionDate() {
        return this.productionDate;
    }

    @Override
    public Date getCreationDate() {
        return this.productionDate;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public Date getExpiredCertsOnCRL() {
        return this.expiredCertsOnCRL;
    }

    public Date getArchiveCutOff() {
        return this.archiveCutOff;
    }

    public boolean isCertHashPresent() {
        return this.certHashPresent;
    }

    public boolean isCertHashMatch() {
        return this.certHashMatch;
    }

    public RevocationReason getReason() {
        return this.reason;
    }

    public String getRevocationTokenKey() {
        return this.revocationTokenKey;
    }

    public void setRevocationTokenKey(String key) {
        this.revocationTokenKey = key;
    }

    public abstract void initInfo();

    public abstract boolean isValid();

    @Override
    public String getDSSIdAsString() {
        return "R-" + super.getDSSIdAsString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.productionDate == null ? 0 : this.productionDate.hashCode());
        result = 31 * result + (this.relatedCertificate == null ? 0 : this.relatedCertificate.getDSSIdAsString().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RevocationToken other = (RevocationToken)obj;
        if (this.productionDate == null ? other.productionDate != null : !this.productionDate.equals(other.productionDate)) {
            return false;
        }
        return !(this.relatedCertificate == null ? other.relatedCertificate != null : !this.relatedCertificate.equals(other.relatedCertificate));
    }
}

