/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.revocation.OnlineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryRevocationSource<T extends RevocationToken>
implements RevocationSource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRevocationSource.class);
    private static final long serialVersionUID = 8116937707098957391L;
    protected OnlineRevocationSource<T> proxiedSource;
    private Long defaultNextUpdateDelay;
    private Long maxNextUpdateDelay;
    private boolean removeExpired = true;

    public abstract List<String> initRevocationTokenKey(CertificateToken var1);

    protected abstract T findRevocation(String var1, CertificateToken var2, CertificateToken var3);

    protected abstract void insertRevocation(T var1);

    protected abstract void updateRevocation(T var1);

    protected abstract void removeRevocation(T var1);

    public void setDefaultNextUpdateDelay(Long defaultNextUpdateDelay) {
        this.defaultNextUpdateDelay = defaultNextUpdateDelay == null ? null : Long.valueOf(defaultNextUpdateDelay * 1000L);
    }

    public void setMaxNextUpdateDelay(Long maxNextUpdateDelay) {
        this.maxNextUpdateDelay = maxNextUpdateDelay == null ? null : Long.valueOf(maxNextUpdateDelay * 1000L);
    }

    public void setProxySource(OnlineRevocationSource<T> proxiedSource) {
        this.proxiedSource = proxiedSource;
    }

    public void setRemoveExpired(boolean removeExpired) {
        this.removeExpired = removeExpired;
    }

    @Override
    public T getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, false);
    }

    public T getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        if (certificateToken == null || issuerCertificateToken == null) {
            LOG.warn("Certificate token or issuer's certificate token is null. Cannot get a revocation token!");
            return null;
        }
        List<String> keys = this.initRevocationTokenKey(certificateToken);
        if (forceRefresh) {
            LOG.info("Cache is skipped to retrieve the revocation token for certificate '{}'", (Object)certificateToken.getDSSIdAsString());
        } else {
            T cachedRevocationToken = this.extractRevocationFromCacheSource(certificateToken, issuerCertificateToken, keys);
            if (cachedRevocationToken != null) {
                return cachedRevocationToken;
            }
        }
        return this.extractAndInsertRevocationTokenFromProxiedSource(certificateToken, issuerCertificateToken, keys);
    }

    private T extractRevocationFromCacheSource(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> keys) {
        Iterator<String> keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            T revocationToken = this.findRevocation(key, certificateToken, issuerCertificateToken);
            if (revocationToken != null) {
                if (this.isNotExpired(revocationToken)) {
                    LOG.info("Revocation token for certificate '{}' is loaded from the cache", (Object)certificateToken.getDSSIdAsString());
                    return revocationToken;
                }
                LOG.debug("Revocation token is expired");
                if (!this.removeExpired) continue;
                this.removeRevocation(revocationToken);
                keyIterator.remove();
                continue;
            }
            keyIterator.remove();
        }
        return null;
    }

    private T extractAndInsertRevocationTokenFromProxiedSource(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> keys) {
        if (this.proxiedSource == null) {
            LOG.warn("Proxied revocation source is not initialized for the called RevocationSource!");
            return null;
        }
        Object newToken = this.proxiedSource.getRevocationToken(certificateToken, issuerCertificateToken);
        if (newToken != null && ((RevocationToken)newToken).isValid()) {
            if (!keys.contains(((RevocationToken)newToken).getRevocationTokenKey())) {
                LOG.info("Revocation token for certificate '{}' is added into the cache", (Object)certificateToken.getDSSIdAsString());
                this.insertRevocation(newToken);
            } else {
                LOG.info("Revocation token for certificate '{}' is updated in the cache", (Object)certificateToken.getDSSIdAsString());
                this.updateRevocation(newToken);
            }
        }
        return newToken;
    }

    private boolean isNotExpired(T token) {
        Date thisUpdate = ((RevocationToken)token).getThisUpdate();
        Date nextUpdate = ((RevocationToken)token).getNextUpdate();
        if (nextUpdate == null && this.defaultNextUpdateDelay != null && thisUpdate != null) {
            nextUpdate = new Date(thisUpdate.getTime() + this.defaultNextUpdateDelay);
        }
        if (nextUpdate != null) {
            Date maxNextUpdate;
            if (this.maxNextUpdateDelay != null && thisUpdate != null && nextUpdate.after(maxNextUpdate = new Date(thisUpdate.getTime() + this.maxNextUpdateDelay))) {
                nextUpdate = maxNextUpdate;
            }
            return nextUpdate.after(new Date());
        }
        return false;
    }
}

