/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.Protocol;
import eu.europa.esig.dss.spi.x509.revocation.OnlineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineCRLSource
implements CRLSource,
RevocationSourceAlternateUrlsSupport<CRLToken>,
OnlineRevocationSource<CRLToken> {
    private static final long serialVersionUID = 6912729291417315212L;
    private static final Logger LOG = LoggerFactory.getLogger(OnlineCRLSource.class);
    private Protocol preferredProtocol;
    private DataLoader dataLoader;

    public OnlineCRLSource() {
        this.dataLoader = new CommonsDataLoader();
        LOG.trace("+OnlineCRLSource with the default data loader.");
    }

    public OnlineCRLSource(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
        LOG.trace("+OnlineCRLSource with the specific data loader.");
    }

    public void setPreferredProtocol(Protocol preferredProtocol) {
        this.preferredProtocol = preferredProtocol;
    }

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    @Override
    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, Collections.emptyList());
    }

    @Override
    public CRLToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken, List<String> alternativeUrls) {
        if (certificateToken == null) {
            return null;
        }
        if (issuerToken == null) {
            return null;
        }
        if (Utils.isCollectionNotEmpty(alternativeUrls)) {
            LOG.info("CRL alternative urls : {}", (Object)alternativeUrls);
        }
        String dssIdAsString = certificateToken.getDSSIdAsString();
        List<String> crlUrls = DSSASN1Utils.getCrlUrls(certificateToken);
        if (Utils.isCollectionEmpty(crlUrls) && Utils.isCollectionEmpty(alternativeUrls)) {
            LOG.debug("No CRL location found for {}", (Object)dssIdAsString);
            return null;
        }
        crlUrls.addAll(alternativeUrls);
        this.prioritize(crlUrls);
        DataLoader.DataAndUrl dataAndUrl = this.downloadCrl(crlUrls);
        if (dataAndUrl == null) {
            return null;
        }
        try {
            CRLBinary crlBinary = new CRLBinary(dataAndUrl.getData());
            CRLValidity crlValidity = CRLUtils.buildCRLValidity((CRLBinary)crlBinary, (CertificateToken)issuerToken);
            CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
            crlToken.setOrigins(Collections.singleton(RevocationOrigin.EXTERNAL));
            crlToken.setSourceURL(dataAndUrl.getUrlString());
            crlToken.setAvailable(true);
            crlToken.setRevocationTokenKey(DSSRevocationUtils.getCRLRevocationTokenKey(dataAndUrl.getUrlString()));
            return crlToken;
        }
        catch (IOException e) {
            LOG.warn("Unable to parse/validate the CRL (url:" + dataAndUrl.getUrlString() + ") : " + e.getMessage(), e);
            return null;
        }
    }

    private DataLoader.DataAndUrl downloadCrl(List<String> downloadUrls) {
        try {
            return this.dataLoader.get(downloadUrls);
        }
        catch (DSSException e) {
            LOG.warn("Unable to download CRL from URLs {}", (Object)downloadUrls, (Object)e);
            return null;
        }
    }

    private void prioritize(List<String> urls) {
        if (this.preferredProtocol != null) {
            ArrayList<String> priorityUrls = new ArrayList<String>();
            for (String url : urls) {
                if (!this.preferredProtocol.isTheSame(url)) continue;
                priorityUrls.add(url);
            }
            urls.removeAll(priorityUrls);
            for (int ii = priorityUrls.size() - 1; ii >= 0; --ii) {
                urls.add(0, (String)priorityUrls.get(ii));
            }
        }
    }
}

