/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.visible;

import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class FontUtils {
    private FontUtils() {
    }

    public static Font computeProperFont(Font font, float size, int dpi) {
        float fontSize = CommonDrawerUtils.computeProperSize(size, dpi);
        return font.deriveFont(fontSize);
    }

    public static FontMetrics getFontMetrics(Font font) {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics g2 = img.getGraphics();
        g2.setFont(font);
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        g2.dispose();
        return fontMetrics;
    }

    public static Dimension computeSize(DSSFont dssFont, String text, float margin) {
        return FontUtils.computeSize(dssFont.getJavaFont(), text, margin);
    }

    public static Dimension computeSize(Font font, String text, float margin) {
        return FontUtils.computeSize(FontUtils.getFontMetrics(font), text, margin);
    }

    public static Dimension computeSize(FontMetrics fontMetrics, String text, float margin) {
        String[] lines = text.split("\\r?\\n");
        float width = 0.0f;
        for (String line : lines) {
            float lineWidth = fontMetrics.stringWidth(line);
            if (!(lineWidth > width)) continue;
            width = lineWidth;
        }
        float doubleMargin = margin * 2.0f;
        float height = (float)(fontMetrics.getHeight() * lines.length) + doubleMargin;
        Dimension dimension = new Dimension();
        dimension.setSize(width += doubleMargin, height);
        return dimension;
    }
}

