/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible;

import eu.europa.esig.dss.pades.SignatureImageParameters;
import org.apache.pdfbox.pdmodel.PDPage;

public class ImageRotationUtils {
    public static final String SUPPORTED_ANGLES_ERROR_MESSAGE = "rotation angle must be 90, 180, 270 or 360 (0)";
    public static final int ANGLE_360 = 360;
    public static final int ANGLE_90 = 90;
    public static final int ANGLE_180 = 180;
    public static final int ANGLE_270 = 270;

    private ImageRotationUtils() {
    }

    private static boolean needRotation(SignatureImageParameters.VisualSignatureRotation visualSignatureRotation) {
        return visualSignatureRotation != null && !SignatureImageParameters.VisualSignatureRotation.NONE.equals((Object)visualSignatureRotation);
    }

    public static int getRotation(SignatureImageParameters.VisualSignatureRotation visualSignatureRotation) {
        return ImageRotationUtils.getRotation(visualSignatureRotation, 0);
    }

    public static int getRotation(SignatureImageParameters.VisualSignatureRotation visualSignatureRotation, PDPage pdPage) {
        return ImageRotationUtils.getRotation(visualSignatureRotation, pdPage.getRotation());
    }

    private static int getRotation(SignatureImageParameters.VisualSignatureRotation visualSignatureRotation, int pageDefaultRotation) {
        int rotate = 360;
        if (ImageRotationUtils.needRotation(visualSignatureRotation)) {
            switch (visualSignatureRotation) {
                case AUTOMATIC: {
                    rotate = 360 - pageDefaultRotation;
                    break;
                }
                case ROTATE_90: {
                    rotate = 90;
                    break;
                }
                case ROTATE_180: {
                    rotate = 180;
                    break;
                }
                case ROTATE_270: {
                    rotate = 270;
                    break;
                }
                default: {
                    throw new IllegalStateException(SUPPORTED_ANGLES_ERROR_MESSAGE);
                }
            }
        }
        return rotate;
    }

    public static boolean isSwapOfDimensionsRequired(SignatureImageParameters.VisualSignatureRotation visualSignatureRotation) {
        return ImageRotationUtils.isSwapOfDimensionsRequired(ImageRotationUtils.getRotation(visualSignatureRotation));
    }

    public static boolean isSwapOfDimensionsRequired(int rotation) {
        return 90 == rotation || 270 == rotation;
    }
}

