/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.CertificationPermission;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.AbstractPDFSignatureService;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PdfCMSInfo;
import eu.europa.esig.dss.pdf.PdfDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSigDict;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.PdfBoxSignatureDrawerFactory;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxSignatureService
extends AbstractPDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxSignatureService.class);

    public PdfBoxSignatureService(boolean timestamp, PdfBoxSignatureDrawerFactory signatureDrawerFactory) {
        super(timestamp, signatureDrawerFactory);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] digest(DSSDocument toSignDocument, PAdESSignatureParameters parameters, DigestAlgorithm digestAlgorithm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument sign(DSSDocument toSignDocument, byte[] signatureValue, PAdESSignatureParameters parameters, DigestAlgorithm digestAlgorithm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] signDocumentAndReturnDigest(PAdESSignatureParameters parameters, final byte[] signatureBytes, OutputStream fileOutputStream, PDDocument pdDocument, DigestAlgorithm digestAlgorithm) {
        byte[] byArray;
        final MessageDigest digest = DSSUtils.getMessageDigest(digestAlgorithm);
        SignatureInterface signatureInterface = new SignatureInterface(){

            @Override
            public byte[] sign(InputStream content) throws IOException {
                int count;
                byte[] b = new byte[4096];
                while ((count = content.read(b)) > 0) {
                    digest.update(b, 0, count);
                }
                return signatureBytes;
            }
        };
        PDSignature pdSignature = this.createSignatureDictionary(parameters, pdDocument);
        SignatureOptions options = new SignatureOptions();
        try {
            options.setPreferredSignatureSize(parameters.getSignatureSize());
            SignatureImageParameters imageParameters = this.getImageParameters(parameters);
            if (imageParameters != null && this.signatureDrawerFactory != null) {
                PdfBoxSignatureDrawer signatureDrawer = (PdfBoxSignatureDrawer)this.signatureDrawerFactory.getSignatureDrawer(imageParameters);
                signatureDrawer.init(imageParameters, pdDocument, options);
                signatureDrawer.draw();
            }
            pdDocument.addSignature(pdSignature, signatureInterface, options);
            this.saveDocumentIncrementally(parameters, fileOutputStream, pdDocument);
            byArray = digest.digest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    options.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(e);
            }
        }
        options.close();
        return byArray;
    }

    private PDSignature createSignatureDictionary(PAdESSignatureParameters parameters, PDDocument pdDocument) {
        PDSignature signature = !this.timestamp && Utils.isStringNotEmpty(parameters.getSignatureFieldId()) ? this.findExistingSignature(pdDocument, parameters.getSignatureFieldId()) : new PDSignature();
        COSName currentType = COSName.getPDFName(this.getType());
        signature.setType(currentType);
        signature.setFilter(COSName.getPDFName(this.getFilter(parameters)));
        signature.setSubFilter(COSName.getPDFName(this.getSubFilter(parameters)));
        if (COSName.SIG.equals(currentType)) {
            CertificationPermission permission;
            signature.setName(this.getSignatureName(parameters));
            if (Utils.isStringNotEmpty(parameters.getContactInfo())) {
                signature.setContactInfo(parameters.getContactInfo());
            }
            if (Utils.isStringNotEmpty(parameters.getLocation())) {
                signature.setLocation(parameters.getLocation());
            }
            if (Utils.isStringNotEmpty(parameters.getReason())) {
                signature.setReason(parameters.getReason());
            }
            if ((permission = parameters.getPermission()) != null && !this.containsFilledSignature(pdDocument)) {
                this.setMDPPermission(pdDocument, signature, permission.getCode());
            }
            Calendar cal = Calendar.getInstance();
            Date signingDate = parameters.bLevel().getSigningDate();
            cal.setTime(signingDate);
            signature.setSignDate(cal);
        }
        return signature;
    }

    private PDSignature findExistingSignature(PDDocument doc, String sigFieldName) {
        PDSignatureField signatureField;
        PDAcroForm acroForm = doc.getDocumentCatalog().getAcroForm();
        if (acroForm != null && (signatureField = (PDSignatureField)acroForm.getField(sigFieldName)) != null) {
            PDSignature signature = signatureField.getSignature();
            if (signature == null) {
                signature = new PDSignature();
                signatureField.getCOSObject().setItem(COSName.V, (COSObjectable)signature);
                return signature;
            }
            throw new DSSException("The signature field '" + sigFieldName + "' can not be signed since its already signed.");
        }
        throw new DSSException("The signature field '" + sigFieldName + "' does not exist.");
    }

    private boolean containsFilledSignature(PDDocument pdDocument) {
        try {
            List<PDSignature> signatures = pdDocument.getSignatureDictionaries();
            for (PDSignature pdSignature : signatures) {
                if (!pdSignature.getCOSObject().containsKey(COSName.BYTERANGE)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOG.warn("Cannot read the existing signature(s)", e);
            return false;
        }
    }

    public void setMDPPermission(PDDocument doc, PDSignature signature, int accessPermissions) {
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("TransformParams"));
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("SigRef"));
        referenceDict.setItem("TransformMethod", (COSBase)COSName.DOCMDP);
        referenceDict.setItem("TransformParams", (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add(referenceDict);
        sigDict.setItem("Reference", (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    public void saveDocumentIncrementally(PAdESSignatureParameters parameters, OutputStream outputStream, PDDocument pdDocument) throws DSSException {
        try {
            if (pdDocument.getDocumentId() == null) {
                pdDocument.setDocumentId(parameters.bLevel().getSigningDate().getTime());
            }
            pdDocument.saveIncremental(outputStream);
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    @Override
    protected List<PdfSignatureOrDocTimestampInfo> getSignatures(CertificatePool validationCertPool, DSSDocument document) {
        ArrayList<PdfSignatureOrDocTimestampInfo> signatures = new ArrayList<PdfSignatureOrDocTimestampInfo>();
        try (InputStream is = document.openStream();
             PDDocument doc = PDDocument.load(is);){
            PdfDssDict dssDictionary = this.getDSSDictionary(doc);
            List<PDSignatureField> pdSignatureFields = doc.getSignatureFields();
            if (Utils.isCollectionNotEmpty(pdSignatureFields)) {
                LOG.debug("{} signature(s) found", (Object)pdSignatureFields.size());
                for (PDSignatureField signatureField : pdSignatureFields) {
                    PDSignature signature = signatureField.getSignature();
                    if (signature == null) {
                        LOG.warn("Signature field with name '{}' does not contain a signature", (Object)signatureField.getPartialName());
                        continue;
                    }
                    try {
                        PdfBoxDict dictionary = new PdfBoxDict(signature.getCOSObject(), doc);
                        PdfSigDict signatureDictionary = new PdfSigDict(dictionary, signatureField.getPartialName());
                        int[] byteRange = signatureDictionary.getByteRange();
                        this.validateByteRange(byteRange);
                        byte[] cms = signatureDictionary.getContents();
                        byte[] signedContent = new byte[]{};
                        if (!this.isContentValueEqualsByteRangeExtraction(document, byteRange, cms, signature.getName())) {
                            LOG.warn("Signature '{}' is skipped. SIWA detected !", (Object)signatureField.getPartialName());
                        } else {
                            signedContent = this.getSignedContent(document, byteRange);
                        }
                        boolean coverAllOriginalBytes = this.isSignatureCoversWholeDocument(document, byteRange);
                        PdfCMSInfo signatureInfo = null;
                        String subFilter = signatureDictionary.getSubFilter();
                        if ("ETSI.RFC3161".equals(subFilter)) {
                            PdfDssDict timestampedDssDictionary = null;
                            if (dssDictionary != null) {
                                timestampedDssDictionary = this.getDSSDictionaryPresentInRevision(this.getOriginalBytes(byteRange, signedContent));
                            }
                            signatureInfo = new PdfDocTimestampInfo(validationCertPool, signatureDictionary, timestampedDssDictionary, cms, signedContent, coverAllOriginalBytes);
                        } else {
                            signatureInfo = new PdfSignatureInfo(validationCertPool, signatureDictionary, dssDictionary, cms, signedContent, coverAllOriginalBytes);
                        }
                        if (signatureInfo == null) continue;
                        signatures.add(signatureInfo);
                    }
                    catch (Exception e) {
                        LOG.error("Unable to parse signature '" + signature.getName() + "' : ", e);
                    }
                }
                this.linkSignatures(signatures);
            }
        }
        catch (Exception e) {
            throw new DSSException("Cannot analyze signatures : " + e.getMessage(), e);
        }
        return signatures;
    }

    private boolean isSignatureCoversWholeDocument(DSSDocument document, int[] byteRange) {
        boolean bl;
        block8: {
            InputStream is = document.openStream();
            try {
                long originalBytesLength = Utils.getInputStreamSize(is);
                long beforeSignatureLength = (long)byteRange[1] - (long)byteRange[0];
                long expectedCMSLength = (long)byteRange[2] - (long)byteRange[1] - (long)byteRange[0];
                long afterSignatureLength = byteRange[3];
                long totalCoveredByByteRange = beforeSignatureLength + expectedCMSLength + afterSignatureLength;
                boolean bl2 = bl = originalBytesLength == totalCoveredByByteRange;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Cannot determine the original file size for the document. Reason : {}", (Object)e.getMessage());
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    private PdfDssDict getDSSDictionaryPresentInRevision(byte[] originalBytes) {
        PdfDssDict pdfDssDict;
        block8: {
            PDDocument doc = PDDocument.load(originalBytes);
            try {
                pdfDssDict = this.getDSSDictionary(doc);
                if (doc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (doc != null) {
                        try {
                            doc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Cannot check in previous revisions if DSS dictionary already exist : " + e.getMessage(), e);
                    return null;
                }
            }
            doc.close();
        }
        return pdfDssDict;
    }

    private PdfDssDict getDSSDictionary(PDDocument doc) {
        PdfBoxDict catalog = new PdfBoxDict(doc.getDocumentCatalog().getCOSObject(), doc);
        return PdfDssDict.extract(catalog);
    }

    /*
     * Exception decompiling
     */
    @Override
    public DSSDocument addDssDictionary(DSSDocument document, List<DSSDictionaryCallback> callbacks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private COSDictionary buildDSSDictionary(PDDocument pdDocument, List<DSSDictionaryCallback> callbacks) throws IOException {
        COSDictionary dss = new COSDictionary();
        Map<String, Long> knownObjects = this.buildKnownObjects(callbacks);
        HashMap<String, COSStream> streams = new HashMap<String, COSStream>();
        HashSet<CRLToken> allCrls = new HashSet<CRLToken>();
        HashSet<OCSPToken> allOcsps = new HashSet<OCSPToken>();
        HashSet<CertificateToken> allCertificates = new HashSet<CertificateToken>();
        COSDictionary vriDictionary = new COSDictionary();
        for (DSSDictionaryCallback callback : callbacks) {
            List<CRLToken> currentCrls;
            List<OCSPToken> currentOcsps;
            COSDictionary sigVriDictionary = new COSDictionary();
            sigVriDictionary.setDirect(true);
            Set<CertificateToken> currentCerts = callback.getCertificates();
            if (Utils.isCollectionNotEmpty(currentCerts)) {
                allCertificates.addAll(currentCerts);
                sigVriDictionary.setItem("Cert", (COSBase)this.buildArray(pdDocument, streams, currentCerts, knownObjects));
            }
            if (Utils.isCollectionNotEmpty(currentOcsps = callback.getOcsps())) {
                allOcsps.addAll(currentOcsps);
                sigVriDictionary.setItem("OCSP", (COSBase)this.buildArray(pdDocument, streams, currentOcsps, knownObjects));
            }
            if (Utils.isCollectionNotEmpty(currentCrls = callback.getCrls())) {
                allCrls.addAll(currentCrls);
                sigVriDictionary.setItem("CRL", (COSBase)this.buildArray(pdDocument, streams, currentCrls, knownObjects));
            }
            String vriKey = callback.getSignature().getVRIKey();
            vriDictionary.setItem(vriKey, (COSBase)sigVriDictionary);
        }
        dss.setItem("VRI", (COSBase)vriDictionary);
        if (Utils.isCollectionNotEmpty(allCertificates)) {
            dss.setItem("Certs", (COSBase)this.buildArray(pdDocument, streams, allCertificates, knownObjects));
        }
        if (Utils.isCollectionNotEmpty(allOcsps)) {
            dss.setItem("OCSPs", (COSBase)this.buildArray(pdDocument, streams, allOcsps, knownObjects));
        }
        if (Utils.isCollectionNotEmpty(allCrls)) {
            dss.setItem("CRLs", (COSBase)this.buildArray(pdDocument, streams, allCrls, knownObjects));
        }
        return dss;
    }

    private COSArray buildArray(PDDocument pdDocument, Map<String, COSStream> streams, Collection<? extends Token> tokens, Map<String, Long> knownObjects) throws IOException {
        COSArray array = new COSArray();
        ArrayList<String> currentObjIds = new ArrayList<String>();
        for (Token token : tokens) {
            String digest = this.getTokenDigest(token);
            if (currentObjIds.contains(digest)) continue;
            Long objectNumber = knownObjects.get(digest);
            if (objectNumber == null) {
                COSStream stream = streams.get(digest);
                if (stream == null) {
                    stream = pdDocument.getDocument().createCOSStream();
                    try (OutputStream unfilteredStream = stream.createOutputStream();){
                        unfilteredStream.write(token.getEncoded());
                        unfilteredStream.flush();
                    }
                    streams.put(digest, stream);
                }
                array.add(stream);
            } else {
                COSObject foundCosObject = this.getByObjectNumber(pdDocument, objectNumber);
                array.add(foundCosObject);
            }
            currentObjIds.add(digest);
        }
        return array;
    }

    private COSObject getByObjectNumber(PDDocument pdDocument, Long objectNumber) {
        List<COSObject> objects = pdDocument.getDocument().getObjects();
        for (COSObject cosObject : objects) {
            if (cosObject.getObjectNumber() != objectNumber.longValue()) continue;
            return cosObject;
        }
        return null;
    }

    @Override
    public List<String> getAvailableSignatureFields(DSSDocument document) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = document.openStream();
             PDDocument pdfDoc = PDDocument.load(is);){
            List<PDSignatureField> signatureFields = pdfDoc.getSignatureFields();
            for (PDSignatureField pdSignatureField : signatureFields) {
                PDSignature signature = pdSignatureField.getSignature();
                if (signature != null) continue;
                result.add(pdSignatureField.getPartialName());
            }
        }
        catch (Exception e) {
            throw new DSSException("Unable to determine signature fields", e);
        }
        return result;
    }

    @Override
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        InMemoryDocument newPdfDoc = null;
        try (InputStream is = document.openStream();
             PDDocument pdfDoc = PDDocument.load(is);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PDPage page = pdfDoc.getPage(parameters.getPage());
            PDDocumentCatalog catalog = pdfDoc.getDocumentCatalog();
            catalog.getCOSObject().setNeedToBeUpdated(true);
            PDAcroForm acroForm = catalog.getAcroForm();
            if (acroForm == null) {
                acroForm = new PDAcroForm(pdfDoc);
                catalog.setAcroForm(acroForm);
                PDResources resources = new PDResources();
                resources.put(COSName.getPDFName("Helv"), PDType1Font.HELVETICA);
                acroForm.setDefaultResources(resources);
                acroForm.setDefaultAppearance("/Helv 0 Tf 0 g");
            }
            PDSignatureField signatureField = new PDSignatureField(acroForm);
            if (Utils.isStringNotBlank(parameters.getName())) {
                signatureField.setPartialName(parameters.getName());
            }
            PDAnnotationWidget widget = signatureField.getWidgets().get(0);
            PDRectangle rect = new PDRectangle(parameters.getOriginX(), parameters.getOriginY(), parameters.getWidth(), parameters.getHeight());
            widget.setRectangle(rect);
            widget.setPage(page);
            page.getAnnotations().add(widget);
            acroForm.getFields().add(signatureField);
            acroForm.getCOSObject().setNeedToBeUpdated(true);
            signatureField.getCOSObject().setNeedToBeUpdated(true);
            page.getCOSObject().setNeedToBeUpdated(true);
            pdfDoc.saveIncremental(baos);
            newPdfDoc = new InMemoryDocument(baos.toByteArray(), "new-document.pdf", MimeType.PDF);
        }
        catch (Exception e) {
            throw new DSSException("Unable to add a new signature fields", e);
        }
        return newPdfDoc;
    }
}

