/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSignatureOrDocTimestampInfoComparator
implements Comparator<PdfSignatureOrDocTimestampInfo>,
Serializable {
    private static final long serialVersionUID = 1451660656464810618L;
    private static final Logger LOG = LoggerFactory.getLogger(PdfSignatureOrDocTimestampInfoComparator.class);

    @Override
    public int compare(PdfSignatureOrDocTimestampInfo o1, PdfSignatureOrDocTimestampInfo o2) {
        int[] byteRange1 = o1.getSignatureByteRange();
        int[] byteRange2 = o2.getSignatureByteRange();
        int begin1 = byteRange1[0];
        int begin2 = byteRange2[0];
        int length1 = byteRange1[1] - byteRange1[0] + (byteRange1[2] - byteRange1[1]) + byteRange1[3];
        int length2 = byteRange2[1] - byteRange2[0] + (byteRange2[2] - byteRange2[1]) + byteRange2[3];
        int end1 = byteRange1[1];
        int end2 = byteRange2[1];
        if (begin1 >= begin2 && length1 < end2) {
            return -1;
        }
        if (begin2 >= begin1 && length2 < end1) {
            return 1;
        }
        if (Arrays.equals(byteRange1, byteRange2)) {
            LOG.warn("More than one signature with the same byte range !");
            return o1.getSigningDate().compareTo(o2.getSigningDate());
        }
        throw new DSSException("Strange byte ranges (" + Arrays.toString(byteRange1) + " / " + Arrays.toString(byteRange2) + ")");
    }
}

