/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pdf.PdfCMSInfo;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSigDict;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.cms.CMSException;

public class PdfSignatureInfo
extends PdfCMSInfo
implements PdfSignatureOrDocTimestampInfo {
    private final CAdESSignature cades;

    public PdfSignatureInfo(CertificatePool validationCertPool, PdfSigDict signatureDictionary, PdfDssDict dssDictionary, byte[] cms, byte[] originalBytes, boolean coverCompleteRevision) throws IOException {
        super(signatureDictionary, dssDictionary, cms, originalBytes, coverCompleteRevision);
        try {
            this.cades = new CAdESSignature(cms, validationCertPool);
            InMemoryDocument detachedContent = new InMemoryDocument(this.getSignedDocumentBytes());
            this.cades.setDetachedContents(Arrays.asList(detachedContent));
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void checkIntegrityOnce() {
        this.cades.checkSignatureIntegrity();
    }

    @Override
    public boolean isTimestamp() {
        return false;
    }

    public CAdESSignature getCades() {
        return this.cades;
    }
}

