/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import java.io.IOException;
import java.util.Date;

public class PdfSigDict {
    private PdfDict dictionary;
    private String sigFieldName;

    public PdfSigDict(PdfDict dictionary) {
        this.dictionary = dictionary;
    }

    public PdfSigDict(PdfDict dictionary, String signatureName) {
        this(dictionary);
        this.sigFieldName = signatureName;
    }

    public String getSigFieldName() {
        return this.sigFieldName;
    }

    public String getSignerName() {
        return this.dictionary.getStringValue("Name");
    }

    public String getContactInfo() {
        return this.dictionary.getStringValue("ContactInfo");
    }

    public String getReason() {
        return this.dictionary.getStringValue("Reason");
    }

    public String getLocation() {
        return this.dictionary.getStringValue("Location");
    }

    public Date getSigningDate() {
        return this.dictionary.getDateValue("M");
    }

    public String getFilter() {
        return this.dictionary.getNameValue("Filter");
    }

    public String getSubFilter() {
        return this.dictionary.getNameValue("SubFilter");
    }

    public byte[] getContents() {
        try {
            return this.dictionary.getBinariesValue("Contents");
        }
        catch (IOException e) {
            throw new DSSException("Unable to retrieve the signature content", e);
        }
    }

    public int[] getByteRange() {
        PdfArray byteRangeArray = this.dictionary.getAsArray("ByteRange");
        if (byteRangeArray == null) {
            throw new DSSException("Unable to retrieve the ByteRange");
        }
        int arraySize = byteRangeArray.size();
        int[] result = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            try {
                result[i] = byteRangeArray.getInt(i);
                continue;
            }
            catch (IOException e) {
                throw new DSSException("Unable to parse integer from the ByteRange", e);
            }
        }
        return result;
    }
}

