/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSigDict;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfCMSInfo
implements PdfSignatureOrDocTimestampInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PdfCMSInfo.class);
    private final PdfSigDict signatureDictionary;
    private final PdfDssDict dssDictionary;
    private final byte[] cms;
    private final byte[] signedBytes;
    private final boolean coverAllOriginalBytes;
    private boolean verified;
    private String uniqueId;
    private List<PdfSignatureOrDocTimestampInfo> outerSignatures = new ArrayList<PdfSignatureOrDocTimestampInfo>();

    protected PdfCMSInfo(PdfSigDict signatureDictionary, PdfDssDict dssDictionary, byte[] cms, byte[] signedContent, boolean coverAllOriginalBytes) {
        this.cms = cms;
        this.signatureDictionary = signatureDictionary;
        this.dssDictionary = dssDictionary;
        this.signedBytes = signedContent;
        this.coverAllOriginalBytes = coverAllOriginalBytes;
    }

    @Override
    public void checkIntegrity() {
        if (!this.verified) {
            this.checkIntegrityOnce();
            LOG.debug("Verify embedded CAdES Signature on signedBytes size {}.", (Object)this.signedBytes.length);
            this.verified = true;
        }
    }

    protected abstract void checkIntegrityOnce();

    @Override
    public byte[] getSignedDocumentBytes() {
        return this.signedBytes;
    }

    @Override
    public PdfDssDict getDssDictionary() {
        return this.dssDictionary;
    }

    @Override
    public String uniqueId() {
        if (this.uniqueId == null) {
            byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA1, this.cms);
            this.uniqueId = Utils.toHex(digest);
        }
        return this.uniqueId;
    }

    @Override
    public byte[] getContents() {
        return this.cms;
    }

    @Override
    public void addOuterSignature(PdfSignatureOrDocTimestampInfo signatureInfo) {
        this.outerSignatures.add(signatureInfo);
    }

    @Override
    public List<PdfSignatureOrDocTimestampInfo> getOuterSignatures() {
        return Collections.unmodifiableList(this.outerSignatures);
    }

    @Override
    public String getSigFieldName() {
        return this.signatureDictionary.getSigFieldName();
    }

    @Override
    public String getSignerName() {
        return this.signatureDictionary.getSignerName();
    }

    @Override
    public String getContactInfo() {
        return this.signatureDictionary.getContactInfo();
    }

    @Override
    public String getReason() {
        return this.signatureDictionary.getReason();
    }

    @Override
    public String getLocation() {
        return this.signatureDictionary.getLocation();
    }

    @Override
    public Date getSigningDate() {
        return this.signatureDictionary.getSigningDate();
    }

    @Override
    public String getFilter() {
        return this.signatureDictionary.getFilter();
    }

    @Override
    public String getSubFilter() {
        return this.signatureDictionary.getSubFilter();
    }

    @Override
    public int[] getSignatureByteRange() {
        return this.signatureDictionary.getByteRange();
    }

    @Override
    public CMSSignedData getCMSSignedData() {
        CMSSignedData cmsSignedData = null;
        try {
            cmsSignedData = new CMSSignedData(this.cms);
        }
        catch (CMSException e) {
            LOG.warn("Cannot create CMSSignedData object from byte array for signature with name [{}]", (Object)this.getSigFieldName());
        }
        return cmsSignedData;
    }

    @Override
    public boolean isCoverAllOriginalBytes() {
        return this.coverAllOriginalBytes;
    }
}

