/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class DSSDictionaryCallback {
    private PAdESSignature signature;
    private List<CRLToken> crls;
    private List<OCSPToken> ocsps;
    private Set<CertificateToken> certificates;

    public PAdESSignature getSignature() {
        return this.signature;
    }

    public void setSignature(PAdESSignature signature) {
        this.signature = signature;
    }

    public Map<Long, byte[]> getStoredCrls() {
        PAdESCRLSource crlSource = (PAdESCRLSource)this.signature.getCRLSource();
        return crlSource.getCrlMap();
    }

    public Map<Long, BasicOCSPResp> getStoredOcspResps() {
        PAdESOCSPSource ocspSource = (PAdESOCSPSource)this.signature.getOCSPSource();
        return ocspSource.getOcspMap();
    }

    public Map<Long, CertificateToken> getStoredCertificates() {
        PAdESCertificateSource certSource = (PAdESCertificateSource)this.signature.getCertificateSource();
        return certSource.getCertificateMap();
    }

    public List<CRLToken> getCrls() {
        return this.crls;
    }

    public void setCrls(List<CRLToken> crls) {
        this.crls = crls;
    }

    public List<OCSPToken> getOcsps() {
        return this.ocsps;
    }

    public void setOcsps(List<OCSPToken> ocsps) {
        this.ocsps = ocsps;
    }

    public Set<CertificateToken> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Set<CertificateToken> certificates) {
        this.certificates = certificates;
    }
}

