/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PDFTimestampService;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfo;
import eu.europa.esig.dss.pdf.PdfSignatureOrDocTimestampInfoComparator;
import eu.europa.esig.dss.pdf.SignatureValidationCallback;
import eu.europa.esig.dss.pdf.visible.SignatureDrawerFactory;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPDFSignatureService
implements PDFSignatureService,
PDFTimestampService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPDFSignatureService.class);
    protected final boolean timestamp;
    protected final SignatureDrawerFactory signatureDrawerFactory;

    protected AbstractPDFSignatureService(boolean timestamp, SignatureDrawerFactory signatureDrawerFactory) {
        this.timestamp = timestamp;
        this.signatureDrawerFactory = signatureDrawerFactory;
    }

    protected String getType() {
        if (this.timestamp) {
            return "DocTimeStamp";
        }
        return "Sig";
    }

    protected String getFilter(PAdESSignatureParameters parameters) {
        if (this.timestamp) {
            if (Utils.isStringNotEmpty(parameters.getTimestampFilter())) {
                return parameters.getTimestampFilter();
            }
            return "Adobe.PPKLite";
        }
        if (Utils.isStringNotEmpty(parameters.getSignatureFilter())) {
            return parameters.getSignatureFilter();
        }
        return "Adobe.PPKLite";
    }

    protected String getSubFilter(PAdESSignatureParameters parameters) {
        if (this.timestamp) {
            if (Utils.isStringNotEmpty(parameters.getTimestampSubFilter())) {
                return parameters.getTimestampSubFilter();
            }
            return "ETSI.RFC3161";
        }
        if (Utils.isStringNotEmpty(parameters.getSignatureSubFilter())) {
            return parameters.getSignatureSubFilter();
        }
        return "ETSI.CAdES.detached";
    }

    protected SignatureImageParameters getImageParameters(PAdESSignatureParameters parameters) {
        if (this.timestamp) {
            return parameters.getTimestampImageParameters();
        }
        return parameters.getSignatureImageParameters();
    }

    protected String getSignatureName(PAdESSignatureParameters parameters) {
        if (parameters.getSignatureName() != null) {
            return parameters.getSignatureName();
        }
        CertificateToken token = parameters.getSigningCertificate();
        Date date = parameters.bLevel().getSigningDate();
        String encodedDate = Utils.toHex(DSSUtils.digest(DigestAlgorithm.SHA1, Long.toString(date.getTime()).getBytes()));
        if (token == null) {
            return "Unknown signer " + encodedDate;
        }
        return DSSASN1Utils.getHumanReadableName(token) + " " + encodedDate;
    }

    @Override
    public DSSDocument timestamp(DSSDocument document, PAdESSignatureParameters parameters, TSPSource tspSource) {
        DigestAlgorithm timestampDigestAlgorithm = parameters.getSignatureTimestampParameters().getDigestAlgorithm();
        byte[] digest = this.digest(document, parameters, timestampDigestAlgorithm);
        TimeStampToken timeStampToken = tspSource.getTimeStampResponse(timestampDigestAlgorithm, digest);
        byte[] encoded = DSSASN1Utils.getDEREncoded(timeStampToken);
        return this.sign(document, encoded, parameters, timestampDigestAlgorithm);
    }

    @Override
    public void validateSignatures(CertificatePool validationCertPool, DSSDocument document, SignatureValidationCallback callback) {
        List<PdfSignatureOrDocTimestampInfo> signaturesFound = this.getSignatures(validationCertPool, document);
        for (PdfSignatureOrDocTimestampInfo pdfSignatureOrDocTimestampInfo : signaturesFound) {
            callback.validate(pdfSignatureOrDocTimestampInfo);
        }
    }

    protected abstract List<PdfSignatureOrDocTimestampInfo> getSignatures(CertificatePool var1, DSSDocument var2);

    protected void linkSignatures(List<PdfSignatureOrDocTimestampInfo> signatures) {
        Collections.sort(signatures, new PdfSignatureOrDocTimestampInfoComparator());
        ArrayList<PdfSignatureOrDocTimestampInfo> previousList = new ArrayList<PdfSignatureOrDocTimestampInfo>();
        for (PdfSignatureOrDocTimestampInfo sig : signatures) {
            if (Utils.isCollectionNotEmpty(previousList)) {
                for (PdfSignatureOrDocTimestampInfo previous : previousList) {
                    previous.addOuterSignature(sig);
                }
            }
            previousList.add(sig);
        }
    }

    protected byte[] getSignedContent(DSSDocument dssDocument, int[] byteRange) throws IOException {
        int beginning = byteRange[0];
        int startSigValueContent = byteRange[1];
        int endSigValueContent = byteRange[2];
        int endValue = byteRange[3];
        byte[] signedContentByteArray = new byte[startSigValueContent + endValue];
        try (InputStream is = dssDocument.openStream();){
            DSSUtils.skipAvailableBytes(is, beginning);
            DSSUtils.readAvailableBytes(is, signedContentByteArray, 0, startSigValueContent);
            DSSUtils.skipAvailableBytes(is, (long)endSigValueContent - (long)startSigValueContent - (long)beginning);
            DSSUtils.readAvailableBytes(is, signedContentByteArray, startSigValueContent, endValue);
        }
        catch (IllegalStateException e) {
            LOG.error("Cannot extract signed content. Reason : {}", (Object)e.getMessage());
        }
        return signedContentByteArray;
    }

    protected boolean isContentValueEqualsByteRangeExtraction(DSSDocument document, int[] byteRange, byte[] cms, String signatureName) {
        boolean match = false;
        try {
            byte[] cmsWithByteRange = this.getSignatureValue(document, byteRange);
            match = Arrays.equals(cms, cmsWithByteRange);
            if (!match) {
                LOG.warn("Conflict between /Content and ByteRange for Signature '{}'.", (Object)signatureName);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            String message = String.format("Unable to retrieve data from the ByteRange (%s to %s)", byteRange[0] + byteRange[1], byteRange[2]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, e);
            }
            LOG.error(message);
        }
        return match;
    }

    protected byte[] getSignatureValue(DSSDocument dssDocument, int[] byteRange) throws IOException {
        int endSigValueContent = byteRange[2] - 1;
        int startSigValueContent = byteRange[0] + byteRange[1] + 1;
        int signatureValueArraySize = endSigValueContent - startSigValueContent;
        if (signatureValueArraySize < 1) {
            throw new DSSException("The byte range present in the document is not valid! SignatureValue size cannot be negative or equal to zero!");
        }
        byte[] signatureValueArray = new byte[signatureValueArraySize];
        try (InputStream is = dssDocument.openStream();){
            DSSUtils.skipAvailableBytes(is, startSigValueContent);
            DSSUtils.readAvailableBytes(is, signatureValueArray);
        }
        catch (IllegalStateException e) {
            LOG.error("Cannot extract signature value. Reason : {}", (Object)e.getMessage());
        }
        return Utils.fromHex(new String(signatureValueArray));
    }

    protected byte[] getOriginalBytes(int[] byteRange, byte[] signedContent) {
        int length = byteRange[1];
        byte[] result = new byte[length];
        System.arraycopy(signedContent, 0, result, 0, length);
        return result;
    }

    protected void validateByteRange(int[] byteRange) {
        if (byteRange == null || byteRange.length != 4) {
            throw new DSSException("Incorrect ByteRange size");
        }
        int a = byteRange[0];
        int b = byteRange[1];
        int c = byteRange[2];
        int d = byteRange[3];
        if (a != 0) {
            throw new DSSException("The ByteRange must cover start of file");
        }
        if (b <= 0) {
            throw new DSSException("The first hash part doesn't cover anything");
        }
        if (c <= b) {
            throw new DSSException("The second hash part must start after the first hash part");
        }
        if (d <= 0) {
            throw new DSSException("The second hash part doesn't cover anything");
        }
    }

    protected Map<String, Long> buildKnownObjects(List<DSSDictionaryCallback> callbacks) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (DSSDictionaryCallback callback : callbacks) {
            String tokenKey;
            Map.Entry<Long, CertificateToken> certEntry2;
            Map<Long, CertificateToken> storedCertificates = callback.getStoredCertificates();
            for (Map.Entry<Long, CertificateToken> certEntry2 : storedCertificates.entrySet()) {
                String tokenKey2 = this.getTokenDigest(certEntry2.getValue());
                if (result.containsKey(tokenKey2)) continue;
                result.put(tokenKey2, (Long)certEntry2.getKey());
            }
            Map<Long, BasicOCSPResp> storedOcspResps = callback.getStoredOcspResps();
            certEntry2 = storedOcspResps.entrySet().iterator();
            while (certEntry2.hasNext()) {
                Map.Entry ocspEntry = (Map.Entry)certEntry2.next();
                OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp((BasicOCSPResp)ocspEntry.getValue());
                tokenKey = Utils.toBase64(DSSUtils.digest(DigestAlgorithm.SHA256, DSSRevocationUtils.getEncoded(ocspResp)));
                if (result.containsKey(tokenKey)) continue;
                result.put(tokenKey, (Long)ocspEntry.getKey());
            }
            Map<Long, byte[]> storedCrls = callback.getStoredCrls();
            for (Map.Entry<Long, byte[]> crlEntry : storedCrls.entrySet()) {
                tokenKey = Utils.toBase64(DSSUtils.digest(DigestAlgorithm.SHA256, crlEntry.getValue()));
                if (result.containsKey(tokenKey)) continue;
                result.put(tokenKey, crlEntry.getKey());
            }
        }
        return result;
    }

    protected String getTokenDigest(Token token) {
        return Utils.toBase64(token.getDigest(DigestAlgorithm.SHA256));
    }
}

