/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.scope;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.scope.PdfByteRangeSignatureScope;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.ArrayList;
import java.util.List;

public class PAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder<PAdESSignature> {
    @Override
    public List<SignatureScope> findSignatureScope(PAdESSignature pAdESSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        PdfSignatureInfo pdfSignature = pAdESSignature.getPdfSignatureInfo();
        if (pdfSignature.isCoverAllOriginalBytes()) {
            result.add(new FullSignatureScope("Full PDF", this.getOriginalPdfDigest(pAdESSignature)));
        } else if (pAdESSignature.hasOuterSignatures()) {
            int outerSignatureSize = pdfSignature.getOuterSignatures().size();
            result.add(new PdfByteRangeSignatureScope("PDF previous version #" + outerSignatureSize, pdfSignature.getSignatureByteRange(), this.getOriginalPdfDigest(pAdESSignature)));
        } else {
            result.add(new PdfByteRangeSignatureScope("Partial PDF", pdfSignature.getSignatureByteRange(), this.getOriginalPdfDigest(pAdESSignature)));
        }
        return result;
    }

    private Digest getOriginalPdfDigest(PAdESSignature padesSignature) {
        return this.getDigest(this.getOriginalPdfBytes(padesSignature));
    }

    private byte[] getOriginalPdfBytes(PAdESSignature padesSignature) {
        InMemoryDocument originalPDF = PAdESUtils.getOriginalPDF(padesSignature);
        return originalPDF.getBytes();
    }
}

