/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.validation.PAdESCRLSource;
import eu.europa.esig.dss.pades.validation.PAdESCertificateSource;
import eu.europa.esig.dss.pades.validation.PAdESOCSPSource;
import eu.europa.esig.dss.pades.validation.PAdESTimestampSource;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureInfo;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESSignature
extends CAdESSignature {
    private static final long serialVersionUID = 3818555396958720967L;
    private static final Logger LOG = LoggerFactory.getLogger(PAdESSignature.class);
    private final DSSDocument document;
    private final PdfDssDict dssDictionary;
    private final PdfSignatureInfo pdfSignatureInfo;

    protected PAdESSignature(DSSDocument document, PdfSignatureInfo pdfSignatureInfo, CertificatePool certPool) throws DSSException {
        super(pdfSignatureInfo.getCades().getCmsSignedData(), certPool, pdfSignatureInfo.getCades().getDetachedContents());
        this.document = document;
        this.dssDictionary = pdfSignatureInfo.getDssDictionary();
        this.pdfSignatureInfo = pdfSignatureInfo;
    }

    @Override
    public SignatureForm getSignatureForm() {
        if (this.hasPKCS7SubFilter()) {
            return SignatureForm.PKCS7;
        }
        return SignatureForm.PAdES;
    }

    @Override
    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new PAdESCertificateSource(this.dssDictionary, super.getCmsSignedData(), this.certPool);
        }
        return this.offlineCertificateSource;
    }

    @Override
    public SignatureCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            this.signatureCRLSource = new PAdESCRLSource(this.dssDictionary, this.getVRIKey());
        }
        return this.signatureCRLSource;
    }

    @Override
    public SignatureOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new PAdESOCSPSource(this.dssDictionary, this.getVRIKey());
        }
        return this.signatureOCSPSource;
    }

    @Override
    public PAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new PAdESTimestampSource(this, this.certPool);
        }
        return (PAdESTimestampSource)this.signatureTimestampSource;
    }

    @Override
    public Date getSigningTime() {
        return this.pdfSignatureInfo.getSigningDate();
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        String location = this.pdfSignatureInfo.getLocation();
        if (Utils.isStringBlank(location)) {
            return super.getSignatureProductionPlace();
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        signatureProductionPlace.setCountryName(location);
        return signatureProductionPlace;
    }

    @Override
    public String getContentIdentifier() {
        return null;
    }

    @Override
    public String getContentHints() {
        return null;
    }

    @Override
    protected void addReferencesForCertificates(List<TimestampedReference> references) {
        List<CertificateToken> dssDictionaryCertValues = this.getCertificateSource().getDSSDictionaryCertValues();
        for (CertificateToken certificate : dssDictionaryCertValues) {
            this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        List<CertificateToken> vriDictionaryCertValues = this.getCertificateSource().getVRIDictionaryCertValues();
        for (CertificateToken certificate : vriDictionaryCertValues) {
            this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
    }

    @Override
    protected void addReferencesFromRevocationData(List<TimestampedReference> references) {
        List<RevocationToken> vriRevocationTokens = this.getVRIDictionaryRevocationTokens();
        for (RevocationToken revocationToken : vriRevocationTokens) {
            this.addReference(references, new TimestampedReference(revocationToken.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        List<RevocationToken> dssRevocationTokens = this.getDSSDictionaryRevocationTokens();
        for (RevocationToken revocationToken : dssRevocationTokens) {
            this.addReference(references, new TimestampedReference(revocationToken.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateRef> getCertificateRefs() {
        ArrayList<CertificateRef> refs = new ArrayList<CertificateRef>();
        List<CertificateToken> encapsulatedCertificates = this.getCAdESSignature().getCertificateSource().getKeyInfoCertificates();
        this.addCertRefs(refs, encapsulatedCertificates);
        if (this.dssDictionary != null) {
            Map<Long, CertificateToken> certMap = this.dssDictionary.getCERTs();
            this.addCertRefs(refs, certMap.values());
        }
        return refs;
    }

    private void addCertRefs(List<CertificateRef> refs, Collection<CertificateToken> encapsulatedCertificates) {
        for (CertificateToken certificateToken : encapsulatedCertificates) {
            CertificateRef ref = new CertificateRef();
            ref.setCertDigest(new Digest(DigestAlgorithm.SHA1, certificateToken.getDigest(DigestAlgorithm.SHA1)));
            refs.add(ref);
        }
    }

    public CAdESSignature getCAdESSignature() {
        return this.pdfSignatureInfo.getCades();
    }

    @Override
    public SignatureIdentifier buildSignatureIdentifier() {
        CertificateToken certificateToken = this.getSigningCertificateToken();
        TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
        return SignatureIdentifier.buildSignatureIdentifier(this.getSigningTime(), identifier, this.getDigestOfByteRange());
    }

    private String getDigestOfByteRange() {
        int[] signatureByteRange = this.pdfSignatureInfo.getSignatureByteRange();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i : signatureByteRange) {
            baos.write(i);
        }
        return DSSUtils.getMD5Digest(baos.toByteArray());
    }

    @Override
    public int[] getSignatureByteRange() {
        return this.pdfSignatureInfo.getSignatureByteRange();
    }

    @Override
    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] contents = this.pdfSignatureInfo.getContents();
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, contents);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    @Override
    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        boolean dataForLevelPresent = true;
        switch (signatureLevel) {
            case PDF_NOT_ETSI: {
                break;
            }
            case PAdES_BASELINE_LTA: {
                dataForLevelPresent = this.hasLTAProfile() && this.hasLTProfile() && this.hasCAdESDetachedSubFilter();
                break;
            }
            case PKCS7_LTA: {
                dataForLevelPresent = this.hasLTAProfile() && this.hasLTProfile() && this.hasPKCS7SubFilter();
                break;
            }
            case PAdES_BASELINE_LT: {
                dataForLevelPresent = this.hasLTProfile() && (this.hasTProfile() || this.hasLTAProfile()) && this.hasCAdESDetachedSubFilter();
                break;
            }
            case PKCS7_LT: {
                dataForLevelPresent = this.hasLTProfile() && (this.hasTProfile() || this.hasLTAProfile()) && this.hasPKCS7SubFilter();
                break;
            }
            case PAdES_BASELINE_T: {
                dataForLevelPresent = this.hasTProfile() && this.hasCAdESDetachedSubFilter();
                break;
            }
            case PKCS7_T: {
                dataForLevelPresent = this.hasTProfile() && this.hasPKCS7SubFilter();
                break;
            }
            case PAdES_BASELINE_B: {
                dataForLevelPresent = this.hasCAdESDetachedSubFilter();
                break;
            }
            case PKCS7_B: {
                dataForLevelPresent = this.hasPKCS7SubFilter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + (Object)((Object)signatureLevel));
            }
        }
        LOG.debug("Level {} found on document {} = {}", new Object[]{signatureLevel, this.document.getName(), dataForLevelPresent});
        return dataForLevelPresent;
    }

    private boolean hasCAdESDetachedSubFilter() {
        return this.pdfSignatureInfo != null && "ETSI.CAdES.detached".equals(this.pdfSignatureInfo.getSubFilter());
    }

    private boolean hasPKCS7SubFilter() {
        return this.pdfSignatureInfo != null && "adbe.pkcs7.detached".equals(this.pdfSignatureInfo.getSubFilter());
    }

    @Override
    public SignatureLevel[] getSignatureLevels() {
        return new SignatureLevel[]{SignatureLevel.PDF_NOT_ETSI, SignatureLevel.PAdES_BASELINE_B, SignatureLevel.PKCS7_B, SignatureLevel.PAdES_BASELINE_T, SignatureLevel.PKCS7_T, SignatureLevel.PAdES_BASELINE_LT, SignatureLevel.PKCS7_LT, SignatureLevel.PAdES_BASELINE_LTA, SignatureLevel.PKCS7_LTA};
    }

    public boolean hasOuterSignatures() {
        return Utils.isCollectionNotEmpty(this.pdfSignatureInfo.getOuterSignatures());
    }

    public PdfSignatureInfo getPdfSignatureInfo() {
        return this.pdfSignatureInfo;
    }

    @Override
    public String getSignatureFieldName() {
        return this.pdfSignatureInfo.getSigFieldName();
    }

    @Override
    public String getSignerName() {
        return this.pdfSignatureInfo.getSignerName();
    }

    @Override
    public String getFilter() {
        return this.pdfSignatureInfo.getFilter();
    }

    @Override
    public String getSubFilter() {
        return this.pdfSignatureInfo.getSubFilter();
    }

    @Override
    public String getContactInfo() {
        return this.pdfSignatureInfo.getContactInfo();
    }

    @Override
    public String getReason() {
        return this.pdfSignatureInfo.getReason();
    }

    public String getVRIKey() {
        return this.pdfSignatureInfo.uniqueId().toUpperCase();
    }
}

