/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PAdESOCSPSource
extends SignatureOCSPSource {
    private final PdfDssDict dssDictionary;
    private final String vriDictionaryName;
    private transient Map<Long, BasicOCSPResp> ocspMap;

    public PAdESOCSPSource(PdfDssDict dssDictionary) {
        this(dssDictionary, null);
    }

    public PAdESOCSPSource(PdfDssDict dssDictionary, String vriDictionaryName) {
        this.dssDictionary = dssDictionary;
        this.vriDictionaryName = vriDictionaryName;
    }

    @Override
    public void appendContainedOCSPResponses() {
        this.extractDSSOCSPs();
        this.extractVRIOCSPs();
    }

    public Map<Long, BasicOCSPResp> getOcspMap() {
        if (this.ocspMap == null) {
            this.appendContainedOCSPResponses();
        }
        if (this.ocspMap != null) {
            return this.ocspMap;
        }
        return Collections.emptyMap();
    }

    private Map<Long, BasicOCSPResp> getDssOcspMap() {
        if (this.dssDictionary != null) {
            this.ocspMap = this.dssDictionary.getOCSPs();
            return this.ocspMap;
        }
        return Collections.emptyMap();
    }

    private void extractDSSOCSPs() {
        for (BasicOCSPResp basicOCSPResp : this.getDssOcspMap().values()) {
            this.addOCSPResponse(OCSPResponseBinary.build(basicOCSPResp), RevocationOrigin.DSS_DICTIONARY);
        }
    }

    private PdfVRIDict findVriDict() {
        PdfVRIDict vriDictionary = null;
        if (this.dssDictionary != null) {
            List<PdfVRIDict> vriDictList = this.dssDictionary.getVRIs();
            if (this.vriDictionaryName != null && Utils.isCollectionNotEmpty(vriDictList)) {
                for (PdfVRIDict vriDict : vriDictList) {
                    if (!this.vriDictionaryName.equals(vriDict.getName())) continue;
                    vriDictionary = vriDict;
                    break;
                }
            }
        }
        return vriDictionary;
    }

    private void extractVRIOCSPs() {
        PdfVRIDict vriDictionary = this.findVriDict();
        if (vriDictionary != null) {
            for (Map.Entry<Long, BasicOCSPResp> ocspEntry : vriDictionary.getOcspMap().entrySet()) {
                if (!this.ocspMap.containsKey(ocspEntry.getKey())) {
                    this.ocspMap.put(ocspEntry.getKey(), ocspEntry.getValue());
                }
                this.addOCSPResponse(OCSPResponseBinary.build(ocspEntry.getValue()), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }
}

