/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PAdESCRLSource
extends SignatureCRLSource {
    private final PdfDssDict dssDictionary;
    private final String vriDictionaryName;
    private Map<Long, byte[]> crlMap;

    public PAdESCRLSource(PdfDssDict dssDictionary) {
        this(dssDictionary, null);
    }

    public PAdESCRLSource(PdfDssDict dssDictionary, String vriDictionaryName) {
        this.dssDictionary = dssDictionary;
        this.vriDictionaryName = vriDictionaryName;
        this.appendContainedCRLResponses();
    }

    private void appendContainedCRLResponses() {
        this.extractDSSCRLs();
        this.extractVRICRLs();
    }

    public Map<Long, byte[]> getCrlMap() {
        if (this.crlMap == null) {
            this.appendContainedCRLResponses();
        }
        if (this.crlMap != null) {
            return this.crlMap;
        }
        return Collections.emptyMap();
    }

    private Map<Long, byte[]> getDssCrlMap() {
        if (this.dssDictionary != null) {
            this.crlMap = this.dssDictionary.getCRLs();
            return this.crlMap;
        }
        return Collections.emptyMap();
    }

    private void extractDSSCRLs() {
        for (byte[] crl : this.getDssCrlMap().values()) {
            this.addCRLBinary(crl, RevocationOrigin.DSS_DICTIONARY);
        }
    }

    private PdfVRIDict findVriDict() {
        PdfVRIDict vriDictionary = null;
        if (this.dssDictionary != null) {
            List<PdfVRIDict> vriDictList = this.dssDictionary.getVRIs();
            if (this.vriDictionaryName != null && Utils.isCollectionNotEmpty(vriDictList)) {
                for (PdfVRIDict vriDict : vriDictList) {
                    if (!this.vriDictionaryName.equals(vriDict.getName())) continue;
                    vriDictionary = vriDict;
                    break;
                }
            }
        }
        return vriDictionary;
    }

    private void extractVRICRLs() {
        PdfVRIDict vriDictionary = this.findVriDict();
        if (vriDictionary != null) {
            for (Map.Entry<Long, byte[]> crlEntry : vriDictionary.getCrlMap().entrySet()) {
                if (!this.crlMap.containsKey(crlEntry.getKey())) {
                    this.crlMap.put(crlEntry.getKey(), crlEntry.getValue());
                }
                this.addCRLBinary(crlEntry.getValue(), RevocationOrigin.VRI_DICTIONARY);
            }
        }
    }
}

