/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineT;
import eu.europa.esig.dss.cades.signature.CustomContentSigner;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLT;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineLTA;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.signature.PadesCMSSignedDataBuilder;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.List;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESService
extends AbstractSignatureService<PAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESService.class);
    private final PadesCMSSignedDataBuilder padesCMSSignedDataBuilder;

    public PAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.padesCMSSignedDataBuilder = new PadesCMSSignedDataBuilder(certificateVerifier);
        LOG.debug("+ PAdESService created");
    }

    private SignatureExtension<PAdESSignatureParameters> getExtensionProfile(SignatureLevel signatureLevel) {
        switch (signatureLevel) {
            case PAdES_BASELINE_B: {
                return null;
            }
            case PAdES_BASELINE_T: {
                return new PAdESLevelBaselineT(this.tspSource);
            }
            case PAdES_BASELINE_LT: {
                return new PAdESLevelBaselineLT(this.tspSource, this.certificateVerifier);
            }
            case PAdES_BASELINE_LTA: {
                return new PAdESLevelBaselineLTA(this.tspSource, this.certificateVerifier);
            }
        }
        throw new IllegalArgumentException("Signature format '" + (Object)((Object)signatureLevel) + "' not supported");
    }

    @Override
    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        PDFSignatureService pdfSignatureService = PdfObjFactory.newPAdESSignatureService();
        DigestAlgorithm digestAlgorithm = parameters.getContentTimestampParameters().getDigestAlgorithm();
        byte[] messageDigest = pdfSignatureService.digest(toSignDocument, parameters, digestAlgorithm);
        TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, messageDigest);
        TimestampToken token = new TimestampToken(timeStampResponse, TimestampType.CONTENT_TIMESTAMP);
        return token;
    }

    @Override
    public ToBeSigned getDataToSign(DSSDocument toSignDocument, PAdESSignatureParameters parameters) throws DSSException {
        this.assertSigningDateInCertificateValidityRange(parameters);
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId());
        byte[] messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest);
        CMSUtils.generateDetachedCMSSignedData(generator, content);
        byte[] dataToSign = customContentSigner.getOutputStream().toByteArray();
        return new ToBeSigned(dataToSign);
    }

    protected byte[] computeDocumentDigest(DSSDocument toSignDocument, PAdESSignatureParameters parameters) {
        PDFSignatureService pdfSignatureService = PdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.digest(toSignDocument, parameters, parameters.getDigestAlgorithm());
    }

    @Override
    public DSSDocument signDocument(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        this.assertSigningDateInCertificateValidityRange(parameters);
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        byte[] encodedData = this.generateCMSSignedData(toSignDocument, parameters, signatureValue);
        PDFSignatureService pdfSignatureService = PdfObjFactory.newPAdESSignatureService();
        DSSDocument signature = pdfSignatureService.sign(toSignDocument, encodedData, parameters, parameters.getDigestAlgorithm());
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(signatureLevel);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B && signatureLevel != SignatureLevel.PAdES_BASELINE_T && extension != null) {
            signature = extension.extendSignatures(signature, parameters);
        }
        parameters.reinitDeterministicId();
        signature.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        return signature;
    }

    protected byte[] generateCMSSignedData(DSSDocument toSignDocument, PAdESSignatureParameters parameters, SignatureValue signatureValue) {
        SignatureAlgorithm signatureAlgorithm = parameters.getSignatureAlgorithm();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        CustomContentSigner customContentSigner = new CustomContentSigner(signatureAlgorithm.getJCEId(), signatureValue.getValue());
        byte[] messageDigest = this.computeDocumentDigest(toSignDocument, parameters);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.padesCMSSignedDataBuilder.getSignerInfoGeneratorBuilder(parameters, messageDigest);
        CMSSignedDataGenerator generator = this.padesCMSSignedDataBuilder.createCMSSignedDataGenerator(parameters, customContentSigner, signerInfoGeneratorBuilder, null);
        CMSProcessableByteArray content = new CMSProcessableByteArray(messageDigest);
        CMSSignedData data = CMSUtils.generateDetachedCMSSignedData(generator, content);
        if (signatureLevel != SignatureLevel.PAdES_BASELINE_B) {
            CAdESLevelBaselineT cadesLevelBaselineT = new CAdESLevelBaselineT(this.tspSource, false);
            data = cadesLevelBaselineT.extendCMSSignatures(data, parameters);
        }
        return DSSASN1Utils.getDEREncoded(data);
    }

    @Override
    public DSSDocument extendDocument(DSSDocument original, PAdESSignatureParameters parameters) throws DSSException {
        SignatureExtension<PAdESSignatureParameters> extension = this.getExtensionProfile(parameters.getSignatureLevel());
        if (extension != null) {
            DSSDocument extended = extension.extendSignatures(original, parameters);
            extended.setName(this.getFinalFileName(original, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            return extended;
        }
        return original;
    }

    public List<String> getAvailableSignatureFields(DSSDocument document) {
        PDFSignatureService pdfSignatureService = PdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.getAvailableSignatureFields(document);
    }

    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        PDFSignatureService pdfSignatureService = PdfObjFactory.newPAdESSignatureService();
        return pdfSignatureService.addNewSignatureField(document, parameters);
    }
}

