/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pdf.PDFTimestampService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;

class PAdESLevelBaselineT
implements SignatureExtension<PAdESSignatureParameters> {
    private final TSPSource tspSource;

    public PAdESLevelBaselineT(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters params) throws DSSException {
        PDFTimestampService timestampService = PdfObjFactory.newTimestampSignatureService();
        return timestampService.timestamp(document, params, this.tspSource);
    }
}

