/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfObjFactory;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class PAdESLevelBaselineLT
implements SignatureExtension<PAdESSignatureParameters> {
    private final CertificateVerifier certificateVerifier;
    private final TSPSource tspSource;

    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
        this.tspSource = tspSource;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters parameters) throws DSSException {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        List<AdvancedSignature> signatures = pdfDocumentValidator.getSignatures();
        for (AdvancedSignature advancedSignature : signatures) {
            if (!this.isRequireDocumentTimestamp(advancedSignature)) continue;
            PAdESLevelBaselineT padesLevelBaselineT = new PAdESLevelBaselineT(this.tspSource);
            document = padesLevelBaselineT.extendSignatures(document, parameters);
            pdfDocumentValidator = new PDFDocumentValidator(document);
            pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
            break;
        }
        signatures = pdfDocumentValidator.getSignatures();
        LinkedList<DSSDictionaryCallback> callbacks = new LinkedList<DSSDictionaryCallback>();
        for (AdvancedSignature signature : signatures) {
            if (!(signature instanceof PAdESSignature)) continue;
            callbacks.add(this.validate((PAdESSignature)signature));
        }
        PDFSignatureService pDFSignatureService = PdfObjFactory.newPAdESSignatureService();
        return pDFSignatureService.addDssDictionary(document, callbacks);
    }

    private boolean isRequireDocumentTimestamp(AdvancedSignature signature) {
        List<TimestampToken> signatureTimestamps = signature.getSignatureTimestamps();
        List<TimestampToken> archiveTimestamps = signature.getArchiveTimestamps();
        return Utils.isCollectionEmpty(signatureTimestamps) && Utils.isCollectionEmpty(archiveTimestamps);
    }

    protected DSSDictionaryCallback validate(PAdESSignature signature) {
        ValidationContext validationContext = signature.getSignatureValidationContext(this.certificateVerifier);
        DefaultAdvancedSignature.RevocationDataForInclusion revocationsForInclusionInProfileLT = signature.getRevocationDataForInclusion(validationContext);
        DSSDictionaryCallback validationCallback = new DSSDictionaryCallback();
        validationCallback.setSignature(signature);
        validationCallback.setCrls(revocationsForInclusionInProfileLT.crlTokens);
        validationCallback.setOcsps(revocationsForInclusionInProfileLT.ocspTokens);
        Set<CertificateToken> certificatesForInclusion = signature.getCertificatesForInclusion(validationContext);
        certificatesForInclusion.addAll(signature.getCertificateListWithinSignatureAndTimestamps());
        validationCallback.setCertificates(certificatesForInclusion);
        return validationCallback;
    }
}

