/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import java.awt.Color;

public class SignatureImageParameters {
    public static final int DEFAULT_PAGE = 1;
    public static final int NO_SCALING = 100;
    private DSSDocument image;
    private int page = 1;
    private float xAxis;
    private float yAxis;
    private int width;
    private int height;
    private int zoom = 100;
    private Color backgroundColor;
    private Integer dpi;
    private VisualSignatureRotation rotation;
    private VisualSignatureAlignmentHorizontal alignmentHorizontal = VisualSignatureAlignmentHorizontal.NONE;
    private VisualSignatureAlignmentVertical alignmentVertical = VisualSignatureAlignmentVertical.NONE;
    private SignatureImageTextParameters textParameters;

    public DSSDocument getImage() {
        return this.image;
    }

    public void setImage(DSSDocument image) {
        this.image = image;
    }

    public float getxAxis() {
        return this.xAxis;
    }

    public void setxAxis(float xAxis) {
        this.xAxis = xAxis;
    }

    public float getyAxis() {
        return this.yAxis;
    }

    public void setyAxis(float yAxis) {
        this.yAxis = yAxis;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public float getScaleFactor() {
        return (float)this.zoom / 100.0f;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Integer getDpi() {
        return CommonDrawerUtils.getDpi(this.dpi);
    }

    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public SignatureImageTextParameters getTextParameters() {
        return this.textParameters;
    }

    public void setTextParameters(SignatureImageTextParameters textParameters) {
        this.textParameters = textParameters;
    }

    public VisualSignatureRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(VisualSignatureRotation rotation) {
        this.rotation = rotation;
    }

    public VisualSignatureAlignmentHorizontal getVisualSignatureAlignmentHorizontal() {
        return this.alignmentHorizontal;
    }

    public void setAlignmentHorizontal(VisualSignatureAlignmentHorizontal alignmentHorizontal) {
        this.alignmentHorizontal = alignmentHorizontal;
    }

    public VisualSignatureAlignmentVertical getVisualSignatureAlignmentVertical() {
        return this.alignmentVertical;
    }

    public void setAlignmentVertical(VisualSignatureAlignmentVertical alignmentVertical) {
        this.alignmentVertical = alignmentVertical;
    }

    public static enum VisualSignatureRotation {
        NONE,
        AUTOMATIC,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270;

    }

    public static enum VisualSignatureAlignmentVertical {
        NONE,
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum VisualSignatureAlignmentHorizontal {
        NONE,
        LEFT,
        CENTER,
        RIGHT;

    }
}

